/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction.attributes;

import java.util.Optional;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.BaseAttribute;

public class ClassAttribute
extends BaseAttribute<Class> {
    private Class baseClass;

    public ClassAttribute(String name, Class baseClass) {
        super(name);
        this.baseClass = baseClass;
    }

    @Override
    public Class<Class> getValueClass() {
        return Class.class;
    }

    @Override
    public Optional<Class> parseValue(String value) {
        Class<?> clazz;
        try {
            clazz = Class.forName(value);
        }
        catch (ClassNotFoundException e) {
            AncientWarfareNPC.LOG.error("Horse entity class was not found for: " + value);
            return Optional.empty();
        }
        if (!this.baseClass.isAssignableFrom(clazz)) {
            return Optional.empty();
        }
        return Optional.of(clazz);
    }
}

