/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.faction;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public final class FactionEntry {
    public final String playerName;
    private HashMap<String, Integer> factionStandings = new HashMap();

    public FactionEntry(NBTTagCompound tag) {
        this.playerName = tag.func_74779_i("playerName");
        for (String name : FactionRegistry.getFactionNames()) {
            this.factionStandings.put(name, AncientWarfareNPC.statics.getPlayerDefaultStanding(name));
        }
        this.readFromNBT(tag);
    }

    public FactionEntry(String playerName) {
        this.playerName = playerName;
        for (String name : FactionRegistry.getFactionNames()) {
            this.factionStandings.put(name, AncientWarfareNPC.statics.getPlayerDefaultStanding(name));
        }
    }

    public int getStandingFor(String factionName) {
        if (this.factionStandings.containsKey(factionName)) {
            return this.factionStandings.get(factionName);
        }
        return 0;
    }

    public void setStandingFor(String factionName, int standing) {
        this.factionStandings.put(factionName, standing);
    }

    public void adjustStandingFor(String factionName, int adjustment) {
        if (this.factionStandings.containsKey(factionName)) {
            this.setStandingFor(factionName, this.getStandingFor(factionName) + adjustment);
        }
    }

    public final void readFromNBT(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            String name = entryTag.func_74779_i("name");
            this.setStandingFor(name, entryTag.func_74762_e("standing"));
        }
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("playerName", this.playerName);
        NBTTagList entryList = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.factionStandings.entrySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("name", entry.getKey());
            entryTag.func_74768_a("standing", entry.getValue().intValue());
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }
}

