/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerCombatOrder;

public class GuiCombatOrder
extends GuiContainerBase<ContainerCombatOrder> {
    private boolean hasChanged = false;
    private CompositeScrolled area;

    public GuiCombatOrder(ContainerBase container) {
        super(container, 256, 220);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, this.field_147000_g);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        int totalHeight = 8;
        for (int i = 0; i < ((ContainerCombatOrder)((Object)this.getContainer())).combatOrder.size(); ++i) {
            BlockPos pos = (BlockPos)((ContainerCombatOrder)((Object)this.getContainer())).combatOrder.get(i);
            Label label = new Label(8, totalHeight + 1, StringTools.formatPos(pos));
            this.area.addGuiElement(label);
            IndexedButton button = new IndexedButton(120, totalHeight, 12, 12, "+", i){

                @Override
                protected void onPressed() {
                    ((ContainerCombatOrder)((Object)GuiCombatOrder.this.getContainer())).combatOrder.increment(this.index);
                    GuiCombatOrder.this.hasChanged = true;
                    GuiCombatOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            button = new IndexedButton(132, totalHeight, 12, 12, "-", i){

                @Override
                protected void onPressed() {
                    ((ContainerCombatOrder)((Object)GuiCombatOrder.this.getContainer())).combatOrder.decrement(this.index);
                    GuiCombatOrder.this.hasChanged = true;
                    GuiCombatOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            button = new IndexedButton(144, totalHeight, 60, 12, "guistrings.npc.remove_point", i){

                @Override
                protected void onPressed() {
                    GuiCombatOrder.this.hasChanged = true;
                    ((ContainerCombatOrder)((Object)GuiCombatOrder.this.getContainer())).combatOrder.remove(this.index);
                    GuiCombatOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerCombatOrder)((Object)this.getContainer())).close();
        }
        return super.onGuiCloseRequested();
    }

    private class IndexedButton
    extends Button {
        final int index;

        public IndexedButton(int topLeftX, int topLeftY, int width, int height, String text, int index) {
            super(topLeftX, topLeftY, width, height, text);
            this.index = index;
        }
    }
}

