/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.npc.container.ContainerTownHall;
import net.shadowmage.ancientwarfare.npc.gui.GuiTownHallInventory;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class GuiTownHallDeathList
extends GuiContainerBase<ContainerTownHall> {
    private final GuiTownHallInventory parent;
    private CompositeScrolled area;

    public GuiTownHallDeathList(GuiTownHallInventory parent) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, this.field_146999_f, this.field_147000_g - 40);
        this.addGuiElement(this.area);
        Button button = new Button(8, 8, 55, 12, "guistrings.npc.clear_death_list"){

            @Override
            protected void onPressed() {
                ((ContainerTownHall)((Object)GuiTownHallDeathList.this.getContainer())).clearList();
            }
        };
        this.addGuiElement(button);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        List<TileTownHall.NpcDeathEntry> deathList = ((ContainerTownHall)((Object)this.parent.getContainer())).getDeathList();
        int totalHeight = 8;
        for (TileTownHall.NpcDeathEntry entry : deathList) {
            String labelText = I18n.func_135052_a((String)"guistrings.npc.npc_name", (Object[])new Object[0]);
            Label label = new Label(8, totalHeight, labelText + ": " + entry.npcName);
            this.area.addGuiElement(label);
            labelText = I18n.func_135052_a((String)"guistrings.npc.npc_type", (Object[])new Object[0]);
            label = new Label(8, totalHeight += 12, labelText + ": " + I18n.func_135052_a((String)("entity.AncientWarfareNpc." + entry.npcType + ".name"), (Object[])new Object[0]));
            this.area.addGuiElement(label);
            labelText = I18n.func_135052_a((String)"guistrings.npc.death_cause", (Object[])new Object[]{entry.deathCause});
            label = new Label(8, totalHeight += 12, labelText);
            this.area.addGuiElement(label);
            totalHeight += 12;
            if (entry.pos != null && entry.pos.length == 3) {
                labelText = I18n.func_135052_a((String)"guistrings.npc.death_position", (Object[])new Object[]{entry.pos[0], entry.pos[1], entry.pos[2]});
                label = new Label(8, totalHeight, labelText);
                this.area.addGuiElement(label);
                totalHeight += 12;
            }
            labelText = I18n.func_135052_a((String)"guistrings.npc.can_res", (Object[])new Object[]{entry.canRes});
            label = new Label(8, totalHeight, labelText);
            this.area.addGuiElement(label);
            totalHeight += 12;
            if (entry.canRes) {
                labelText = I18n.func_135052_a((String)"guistrings.npc.resurrected", (Object[])new Object[]{entry.resurrected});
                label = new Label(8, totalHeight, labelText);
                this.area.addGuiElement(label);
                totalHeight += 12;
            }
            this.area.addGuiElement(new Line(0, totalHeight - 1, this.field_146999_f, totalHeight - 1, 1, 255));
            totalHeight += 4;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        ((ContainerTownHall)((Object)this.parent.getContainer())).addSlots();
        this.parent.refreshGui();
        return false;
    }
}

