/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;

public class TargetRegistry {
    static final String TARGETS = "targets";
    private static final String LISTS = "lists";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    static Map<String, Set<String>> targetLists = new HashMap<String, Set<String>>();

    private TargetRegistry() {
    }

    public static Optional<Set<String>> parseTargets(JsonObject json) {
        if (!json.has(TARGETS)) {
            return Optional.empty();
        }
        JsonObject targets = JsonUtils.func_152754_s((JsonObject)json, (String)TARGETS);
        HashSet<String> entitiesToTarget = new HashSet<String>();
        if (targets.has(LISTS)) {
            Set<String> lists = JsonHelper.setFromJson(targets.get(LISTS), e -> JsonUtils.func_151206_a((JsonElement)e, (String)""));
            for (String list : lists) {
                if (targetLists.containsKey(list)) {
                    entitiesToTarget.addAll((Collection)targetLists.get(list));
                    continue;
                }
                AncientWarfareCore.LOG.error("Skipping unknown target list - {}", (Object)list);
            }
        }
        if (targets.has(INCLUDE)) {
            entitiesToTarget.addAll(JsonHelper.setFromJson(targets.get(INCLUDE), e -> JsonUtils.func_151206_a((JsonElement)e, (String)"")));
        }
        if (targets.has(EXCLUDE)) {
            entitiesToTarget.removeAll(JsonHelper.setFromJson(targets.get(EXCLUDE), e -> JsonUtils.func_151206_a((JsonElement)e, (String)"")));
        }
        return Optional.of(entitiesToTarget);
    }

    public static class TargetListParser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "target_lists";
        }

        @Override
        public void parse(JsonObject json) {
            targetLists = JsonHelper.mapFromJson(json, Map.Entry::getKey, entry -> JsonHelper.setFromJson((JsonElement)entry.getValue(), e -> JsonUtils.func_151206_a((JsonElement)e, (String)"")));
        }
    }
}

