/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.render.ModelNpc;

public class RenderNpcBase<T extends NpcBase>
extends RenderBiped<T> {
    private static final ModelNpc SMALL_ARMS = new ModelNpc(true);
    private static final ModelNpc REGULAR_ARMS = new ModelNpc(false);
    private boolean isSleeping;
    private List<Integer> renderTasks = new ArrayList<Integer>();

    public RenderNpcBase(RenderManager renderManager) {
        super(renderManager, (ModelBiped)REGULAR_ARMS, 0.6f);
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
    }

    protected void applyRotations(T npc, float parFloat1, float parFloat2, float parFloat3) {
        this.isSleeping = ((NpcBase)npc).isSleeping();
        if (this.isSleeping) {
            float bedDirection = ((NpcBase)npc).getBedOrientationInDegrees();
            if (bedDirection != -1.0f) {
                GlStateManager.func_179114_b((float)bedDirection, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)npc), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                return;
            }
            this.isSleeping = false;
        }
        super.func_77043_a(npc, parFloat1, parFloat2, parFloat3);
    }

    public void doRender(T npc, double x, double y, double z, float par8, float par9) {
        EntityPlayerSP player;
        this.field_77045_g = ((NpcBase)npc).getSkinSettings().renderFemaleModel((NpcBase)npc) ? SMALL_ARMS : REGULAR_ARMS;
        this.isSleeping = ((NpcBase)npc).isSleeping();
        if (this.isSleeping) {
            double xOffset = x - (double)((NpcBase)npc).getBedDirection().func_82601_c() * 0.5;
            double zOffset = z - (double)((NpcBase)npc).getBedDirection().func_82599_e() * 0.5;
            super.func_76986_a(npc, xOffset, y, zOffset, par8, par9);
        } else {
            super.func_76986_a(npc, x, y, z, par8, par9);
        }
        if (this.isSleeping) {
            y -= 1.5;
        }
        if (((NpcBase)npc).isHostileTowards((Entity)(player = Minecraft.func_71410_x().field_71439_g))) {
            if (AWNPCStatics.renderHostileNames.getBoolean()) {
                String name = this.getNameForRender((NpcBase)npc, true);
                if (AWNPCStatics.renderTeamColors.getBoolean()) {
                    ScorePlayerTeam playerTeam = player.field_70170_p.func_96441_U().func_96508_e(player.func_70005_c_());
                    ScorePlayerTeam npcTeam = (ScorePlayerTeam)((NpcBase)npc).func_96124_cp();
                    if (npcTeam != null && npcTeam != playerTeam) {
                        name = npcTeam.func_96668_e() + name + npcTeam.func_96663_f();
                    }
                }
                this.renderColoredLabel((NpcBase)npc, name, x, y, z, 0x20FF0000, -65536);
            }
        } else {
            boolean canBeCommandedBy = ((NpcBase)npc).hasCommandPermissions(player.func_110124_au(), player.func_70005_c_());
            if (AWNPCStatics.renderFriendlyNames.getBoolean()) {
                String name = this.getNameForRender((NpcBase)npc, false);
                if (AWNPCStatics.renderTeamColors.getBoolean()) {
                    ScorePlayerTeam playerTeam = player.field_70170_p.func_96441_U().func_96508_e(player.func_70005_c_());
                    ScorePlayerTeam npcTeam = (ScorePlayerTeam)((NpcBase)npc).func_96124_cp();
                    if (npcTeam != null && npcTeam != playerTeam) {
                        name = npcTeam.func_96668_e() + name + npcTeam.func_96663_f();
                    }
                } else if (!canBeCommandedBy) {
                    name = TextFormatting.DARK_GRAY.toString() + name;
                }
                this.renderColoredLabel((NpcBase)npc, name, x, y, z, 0x20FFFFFF, -1);
            }
            if (canBeCommandedBy && AWNPCStatics.renderAI.getBoolean()) {
                this.renderNpcAITasks((NpcBase)npc, x, y, z);
            }
        }
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.09375f, (float)0.1875f, (float)0.0f);
    }

    protected boolean canRenderName(NpcBase par1EntityLivingBase) {
        return false;
    }

    protected void renderLivingLabel(NpcBase entityIn, String str, double x, double y, double z, int maxDistance) {
    }

    private String getNameForRender(NpcBase npc, boolean hostile) {
        boolean addHealth;
        String customName = npc.func_145818_k_() ? npc.func_95999_t() : npc.func_70005_c_();
        boolean bl = addHealth = hostile && AWNPCStatics.renderHostileHealth.getBoolean() || !hostile && AWNPCStatics.renderFriendlyHealth.getBoolean();
        if (addHealth) {
            customName = customName + " " + this.getHealthForRender(npc);
        }
        return customName;
    }

    private String getHealthForRender(NpcBase npc) {
        return String.format("%.1f", Float.valueOf(npc.func_110143_aJ()));
    }

    private void renderNpcAITasks(NpcBase entity, double x, double y, double z) {
        double d3 = entity.func_70068_e(this.field_76990_c.field_78734_h);
        if (d3 <= 4096.0 && entity.func_70685_l(this.field_76990_c.field_78734_h)) {
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + 0.5f), (float)((float)z));
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tasks = entity.getAITasks();
            for (int i = 0; i < 14; ++i) {
                int mask = 1 << i;
                if ((tasks & mask) == 0) continue;
                this.renderTasks.add(mask);
            }
            int offset = this.renderTasks.size() * 10 / 2;
            int startX = -offset;
            for (int i = 0; i < this.renderTasks.size(); ++i) {
                String icon = this.getIconFor(this.renderTasks.get(i));
                this.renderIcon(icon, startX + i * 20, -16);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            this.renderTasks.clear();
        }
    }

    private void renderColoredLabel(NpcBase entity, String string, double x, double y, double z, int color1, int color2) {
        double d3 = entity.func_70068_e(this.field_76990_c.field_78734_h);
        if (d3 <= 4096.0 && entity.func_70685_l(this.field_76990_c.field_78734_h)) {
            FontRenderer fontrenderer = this.func_76983_a();
            float f = 0.8f;
            float f1 = 0.016666668f * f;
            GlStateManager.func_179094_E();
            float heightScalingOffset = entity.field_70131_O / 6.0f - 0.3f;
            GlStateManager.func_179109_b((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + heightScalingOffset + 0.5f), (float)((float)z));
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179090_x();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int j = fontrenderer.func_78256_a(string) / 2;
            bufferBuilder.func_181662_b((double)(-j - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(-j - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(j + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(j + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(string, -fontrenderer.func_78256_a(string) / 2, 0, color1);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            fontrenderer.func_78276_b(string, -fontrenderer.func_78256_a(string) / 2, 0, color2);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(NpcBase npc) {
        return npc.getTexture();
    }

    private void renderIcon(String tex, int x, int y) {
        Tessellator tess = Tessellator.func_178181_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(tex));
        int halfW = 8;
        int halfH = 8;
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)(x - halfW), (double)(y - halfH), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)(x - halfW), (double)(y + halfH), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + halfW), (double)(y + halfH), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + halfW), (double)(y + -halfH), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    private String getIconFor(int task) {
        switch (task) {
            case 0: {
                return null;
            }
            case 1: {
                return "ancientwarfare:textures/entity/npc/ai/task_attack.png";
            }
            case 2: {
                return "ancientwarfare:textures/entity/npc/ai/task_upkeep.png";
            }
            case 4: {
                return "ancientwarfare:textures/entity/npc/ai/task_upkeep2.png";
            }
            case 8: {
                return "ancientwarfare:textures/entity/npc/ai/task_home.png";
            }
            case 16: {
                return "ancientwarfare:textures/entity/npc/ai/task_work.png";
            }
            case 32: {
                return "ancientwarfare:textures/entity/npc/ai/task_patrol.png";
            }
            case 64: {
                return "ancientwarfare:textures/entity/npc/ai/task_guard.png";
            }
            case 128: {
                return "ancientwarfare:textures/entity/npc/ai/task_follow.png";
            }
            case 256: {
                return "ancientwarfare:textures/entity/npc/ai/task_wander.png";
            }
            case 512: {
                return "ancientwarfare:textures/entity/npc/ai/task_move.png";
            }
            case 1024: {
                return "ancientwarfare:textures/entity/npc/ai/task_alarm.png";
            }
            case 2048: {
                return "ancientwarfare:textures/entity/npc/ai/task_flee.png";
            }
            case 4096: {
                return "ancientwarfare:textures/entity/npc/ai/task_sleep.png";
            }
            case 8192: {
                return "ancientwarfare:textures/entity/npc/ai/task_rain.png";
            }
        }
        return null;
    }
}

