/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.skin;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketEntity;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinManager;

public class NpcSkinSettings {
    private static final ResourceLocation BASE_DEFAULT_TEXTURE = new ResourceLocation("ancientwarfare:textures/entity/npc/npc_default.png");
    public static final String PACKET_TAG_NAME = "skinSettings";
    private static final String PLAYER_NAME_TAG = "playerName";
    private static final String RANDOM_TAG = "random";
    private static final String NPC_TYPE_NAME_TAG = "npcTypeName";
    private static final String NPC_TYPE_SKIN_TAG = "npcTypeSkin";
    private static final String IS_ALEX_MODEL_TAG = "isAlexModel";
    private SkinType skinTypeSelected = SkinType.DEFAULT;
    private boolean playerSkinLoaded = false;
    private ResourceLocation playerSkin = null;
    private String playerName = "";
    private boolean random = true;
    private String npcTypeName = "custom";
    private ResourceLocation npcTypeSkin = null;
    private boolean isAlexModel = false;

    public boolean isAlexModel() {
        return this.isAlexModel;
    }

    public void setAlexModel(boolean alexModel) {
        this.isAlexModel = alexModel;
    }

    public boolean renderFemaleModel(NpcBase npc) {
        if (this.skinTypeSelected == SkinType.DEFAULT) {
            return npc.isFemale();
        }
        return this.isAlexModel;
    }

    public ResourceLocation getTexture(NpcBase npc) {
        switch (this.skinTypeSelected) {
            case PLAYER: {
                this.loadPlayerSkin();
                return this.playerSkin == null ? BASE_DEFAULT_TEXTURE : this.playerSkin;
            }
            case NPC_TYPE: {
                return this.random || this.npcTypeSkin == null ? NpcSkinManager.getNpcTexture(this.npcTypeName, npc.getIDForSkin()).orElse(BASE_DEFAULT_TEXTURE) : this.npcTypeSkin;
            }
        }
        return NpcSkinManager.getNpcTexture(npc.getNpcFullType(), npc.getIDForSkin()).orElse(BASE_DEFAULT_TEXTURE);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("skinTypeSelected", this.skinTypeSelected.func_176610_l());
        if (!this.playerName.isEmpty()) {
            tag.func_74778_a(PLAYER_NAME_TAG, this.playerName);
        }
        if (!this.random) {
            tag.func_74757_a(RANDOM_TAG, false);
        }
        if (!this.npcTypeName.isEmpty()) {
            tag.func_74778_a(NPC_TYPE_NAME_TAG, this.npcTypeName);
        }
        if (this.npcTypeSkin != null) {
            tag.func_74778_a(NPC_TYPE_SKIN_TAG, this.npcTypeSkin.toString());
        }
        if (this.isAlexModel) {
            tag.func_74757_a(IS_ALEX_MODEL_TAG, true);
        }
        return tag;
    }

    public void serializeToBuffer(ByteBuf buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        packetBuffer.func_180714_a(this.skinTypeSelected.func_176610_l());
        packetBuffer.func_180714_a(this.playerName);
        packetBuffer.writeBoolean(this.random);
        packetBuffer.func_180714_a(this.npcTypeName);
        packetBuffer.func_180714_a(this.npcTypeSkin == null ? "" : this.npcTypeSkin.toString().substring(0, Math.min(this.npcTypeSkin.toString().length(), 100)));
        packetBuffer.writeBoolean(this.isAlexModel);
    }

    public static NpcSkinSettings deserializeFromBuffer(ByteBuf buffer) {
        NpcSkinSettings skinSettings = new NpcSkinSettings();
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        skinSettings.skinTypeSelected = SkinType.byName(packetBuffer.func_150789_c(20));
        if (skinSettings.skinTypeSelected == SkinType.PLAYER) {
            skinSettings.playerName = packetBuffer.func_150789_c(40);
        } else {
            packetBuffer.func_150789_c(40);
        }
        if (skinSettings.skinTypeSelected == SkinType.NPC_TYPE) {
            skinSettings.random = packetBuffer.readBoolean();
            skinSettings.npcTypeName = packetBuffer.func_150789_c(30);
            if (!skinSettings.random) {
                String skin = packetBuffer.func_150789_c(100);
                skinSettings.npcTypeSkin = skin.isEmpty() ? null : new ResourceLocation(skin);
            }
        } else {
            packetBuffer.readBoolean();
            packetBuffer.func_150789_c(30);
            packetBuffer.func_150789_c(60);
        }
        skinSettings.isAlexModel = packetBuffer.readBoolean();
        return skinSettings;
    }

    public static NpcSkinSettings deserializeNBT(NBTTagCompound tag) {
        NpcSkinSettings skinSettings = new NpcSkinSettings();
        skinSettings.skinTypeSelected = SkinType.byName(tag.func_74779_i("skinTypeSelected"));
        if (tag.func_74764_b(PLAYER_NAME_TAG)) {
            skinSettings.playerName = tag.func_74779_i(PLAYER_NAME_TAG);
        }
        if (tag.func_74764_b(RANDOM_TAG)) {
            skinSettings.random = tag.func_74767_n(RANDOM_TAG);
        }
        if (tag.func_74764_b(NPC_TYPE_NAME_TAG)) {
            skinSettings.npcTypeName = tag.func_74779_i(NPC_TYPE_NAME_TAG);
        }
        if (tag.func_74764_b(NPC_TYPE_SKIN_TAG)) {
            skinSettings.npcTypeSkin = new ResourceLocation(tag.func_74779_i(NPC_TYPE_SKIN_TAG));
        }
        skinSettings.isAlexModel = tag.func_74767_n(IS_ALEX_MODEL_TAG);
        return skinSettings;
    }

    public NpcSkinSettings minimizeData() {
        NpcSkinSettings skinSettings = new NpcSkinSettings();
        skinSettings.skinTypeSelected = this.skinTypeSelected;
        if (this.skinTypeSelected == SkinType.PLAYER) {
            skinSettings.playerName = this.playerName;
        } else if (this.skinTypeSelected == SkinType.NPC_TYPE) {
            skinSettings.random = this.random;
            skinSettings.npcTypeName = this.npcTypeName;
            if (!this.random) {
                skinSettings.npcTypeSkin = this.npcTypeSkin;
            }
        }
        if (this.skinTypeSelected != SkinType.DEFAULT) {
            skinSettings.isAlexModel = this.isAlexModel;
        }
        return skinSettings;
    }

    private void loadPlayerSkin() {
        Optional<ResourceLocation> plSkin;
        if (!this.playerSkinLoaded && (plSkin = AncientWarfareNPC.proxy.getPlayerSkin(this.playerName)).isPresent()) {
            this.playerSkin = plSkin.get();
            this.playerSkinLoaded = true;
        }
    }

    private void loadPlayerProfile(NpcBase npc) {
        World world = npc.func_130014_f_();
        if (!world.field_72995_K) {
            this.sendEntityPacket(npc, data -> AncientWarfareNPC.proxy.cacheProfile((WorldServer)world, this.playerName).ifPresent(t -> data.func_74782_a("profile", (NBTBase)t)));
        }
    }

    private void sendEntityPacket(NpcBase npc, Consumer<NBTTagCompound> setData) {
        PacketEntity pkt = new PacketEntity((Entity)npc);
        NBTTagCompound data = new NBTTagCompound();
        setData.accept(data);
        pkt.packetData.func_74782_a(PACKET_TAG_NAME, (NBTBase)data);
        NetworkHandler.sendToAllTracking((Entity)npc, pkt);
    }

    public void handlePacketData(NBTTagCompound tag) {
        if (this.skinTypeSelected == SkinType.PLAYER) {
            Optional.ofNullable(NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l(PACKET_TAG_NAME).func_74775_l("profile"))).ifPresent(AncientWarfareNPC.proxy::cacheProfile);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        switch (this.skinTypeSelected) {
            case PLAYER: {
                return I18n.func_135052_a((String)"gui.ancientwarfarenpc.skin_info.player", (Object[])new Object[]{this.playerName});
            }
            case NPC_TYPE: {
                return this.random || this.npcTypeSkin == null ? this.npcTypeName + " " + I18n.func_135052_a((String)"gui.ancientwarfarenpc.skin_info.npc_type_random", (Object[])new Object[0]) : this.npcTypeSkin.toString().replace("ancientwarfare:skinpack/", "").replace(".png", "");
            }
        }
        return I18n.func_135052_a((String)"gui.ancientwarfarenpc.skin_info.default", (Object[])new Object[0]);
    }

    public void setSkinType(SkinType skinType) {
        this.skinTypeSelected = skinType;
    }

    public SkinType getSkinType() {
        return this.skinTypeSelected;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.playerSkinLoaded = false;
        this.playerSkin = null;
    }

    public String getNpcTypeName() {
        return this.npcTypeName;
    }

    public void setNpcTypeName(String npcTypeName) {
        this.npcTypeName = npcTypeName;
    }

    public Optional<ResourceLocation> getNpcTypeSkin() {
        return Optional.ofNullable(this.npcTypeSkin);
    }

    public void resetNpcTypeSkin() {
        this.npcTypeSkin = null;
    }

    public void setNpcTypeSkin(ResourceLocation npcTypeSkin) {
        this.npcTypeSkin = npcTypeSkin;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void onNpcSet(NpcBase npc) {
        this.loadPlayerProfile(npc);
    }

    public static enum SkinType implements IStringSerializable
    {
        DEFAULT,
        PLAYER,
        NPC_TYPE;

        private static final Map<String, SkinType> NAME_TYPE;

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static SkinType byName(String name) {
            return NAME_TYPE.getOrDefault(name, DEFAULT);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (SkinType type : SkinType.values()) {
                builder.put((Object)type.func_176610_l(), (Object)type);
            }
            NAME_TYPE = builder.build();
        }
    }
}

