/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure;

import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.registry.RegistryLoader;
import net.shadowmage.ancientwarfare.structure.AWStructureTab;
import net.shadowmage.ancientwarfare.structure.command.CommandStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.container.ContainerDraftingStation;
import net.shadowmage.ancientwarfare.structure.container.ContainerGateControl;
import net.shadowmage.ancientwarfare.structure.container.ContainerLootBasket;
import net.shadowmage.ancientwarfare.structure.container.ContainerLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.container.ContainerSoundBlock;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvanced;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedBlock;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedInventoryBlock;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedInventoryItem;
import net.shadowmage.ancientwarfare.structure.container.ContainerStake;
import net.shadowmage.ancientwarfare.structure.container.ContainerStatue;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureSelection;
import net.shadowmage.ancientwarfare.structure.container.ContainerTownSelection;
import net.shadowmage.ancientwarfare.structure.datafixes.TileLootFixer;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.entity.EntitySeat;
import net.shadowmage.ancientwarfare.structure.event.EventHandler;
import net.shadowmage.ancientwarfare.structure.event.OneShotEntityDespawnListener;
import net.shadowmage.ancientwarfare.structure.network.PacketSoundBlockPlayerSpecValues;
import net.shadowmage.ancientwarfare.structure.network.PacketStructure;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureRemove;
import net.shadowmage.ancientwarfare.structure.proxy.CommonProxyStructure;
import net.shadowmage.ancientwarfare.structure.registry.EntitySpawnNBTRegistry;
import net.shadowmage.ancientwarfare.structure.registry.StructureBlockRegistry;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;
import net.shadowmage.ancientwarfare.structure.template.datafixes.DataFixManager;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.BlockMetaToBlockStateFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.EntityEquipmentFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.EntityPositionToNBTFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.EntityRuleNameFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.FactionExpansionFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleNameConsolidationFixer;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json.JsonSimplificationFixer;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateLoader;
import net.shadowmage.ancientwarfare.structure.town.WorldTownGenerator;
import net.shadowmage.ancientwarfare.structure.util.CapabilityRespawnData;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Ancient Warfare Structures", modid="ancientwarfarestructure", version="1.12.2-2.7.0.772", dependencies="required-after:ancientwarfare", acceptedMinecraftVersions="[1.12.2]")
public class AncientWarfareStructure {
    public static final String MOD_ID = "ancientwarfarestructure";
    public static final CreativeTabs TAB = new AWStructureTab();
    @Mod.Instance(value="ancientwarfarestructure")
    public static AncientWarfareStructure instance;
    public static final Logger LOG;
    @SidedProxy(clientSide="net.shadowmage.ancientwarfare.structure.proxy.ClientProxyStructure", serverSide="net.shadowmage.ancientwarfare.structure.proxy.CommonProxyStructure")
    public static CommonProxyStructure proxy;
    private AWStructureStatics statics;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.statics = new AWStructureStatics("AncientWarfareStructures");
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        if (AWStructureStatics.enableWorldGen) {
            MinecraftForge.EVENT_BUS.register((Object)WorldGenTickHandler.INSTANCE);
            if (AWStructureStatics.enableStructureGeneration) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)WorldStructureGenerator.INSTANCE, (int)1);
            }
            if (AWStructureStatics.enableTownGeneration) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)WorldTownGenerator.INSTANCE, (int)2);
            }
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "aw_gate"), EntityGate.class, (String)"aw_gate", (int)0, (Object)this, (int)250, (int)200, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "seat"), EntitySeat.class, (String)"AWSeat", (int)1, (Object)this, (int)20, (int)10, (boolean)false);
        PacketBase.registerPacketType(2, PacketStructure.class);
        PacketBase.registerPacketType(11, PacketStructureRemove.class);
        PacketBase.registerPacketType(30, PacketSoundBlockPlayerSpecValues.class);
        NetworkHandler.registerContainer(1, ContainerStructureScanner.class);
        NetworkHandler.registerContainer(2, ContainerStructureSelection.class);
        NetworkHandler.registerContainer(54, ContainerTownSelection.class);
        NetworkHandler.registerContainer(7, ContainerSpawnerAdvanced.class);
        NetworkHandler.registerContainer(8, ContainerSpawnerAdvancedBlock.class);
        NetworkHandler.registerContainer(9, ContainerSpawnerAdvancedInventoryItem.class);
        NetworkHandler.registerContainer(10, ContainerSpawnerAdvancedInventoryBlock.class);
        NetworkHandler.registerContainer(11, ContainerGateControl.class);
        NetworkHandler.registerContainer(58, ContainerGateControl.class);
        NetworkHandler.registerContainer(13, ContainerDraftingStation.class);
        NetworkHandler.registerContainer(48, ContainerSoundBlock.class);
        NetworkHandler.registerContainer(55, ContainerLootChestPlacer.class);
        NetworkHandler.registerContainer(59, ContainerLootBasket.class);
        NetworkHandler.registerContainer(60, ContainerStake.class);
        NetworkHandler.registerContainer(61, ContainerStatue.class);
        proxy.preInit();
        TemplateLoader.INSTANCE.initializeAndExportDefaults();
        RegistryLoader.registerParser(new EntitySpawnNBTRegistry.Parser());
        RegistryLoader.registerParser(new StructureBlockRegistry.Parser());
        CapabilityRespawnData.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
        DataFixManager.registerRuleFixer(new FactionExpansionFixer());
        DataFixManager.registerRuleFixer(new JsonSimplificationFixer());
        DataFixManager.registerRuleFixer(new BlockMetaToBlockStateFixer());
        DataFixManager.registerRuleFixer(new EntityPositionToNBTFixer());
        DataFixManager.registerRuleFixer(new RuleNameConsolidationFixer());
        DataFixManager.registerRuleFixer(new EntityRuleNameFixer());
        DataFixManager.registerRuleFixer(new EntityEquipmentFixer());
        DataFixManager.registerRuleFixer(new TileLootFixer());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        StructurePluginManager.INSTANCE.loadPlugins();
        WorldGenStructureManager.INSTANCE.loadBiomeList();
        TemplateLoader.INSTANCE.loadTemplates();
        this.statics.save();
        AWStructureStatics.logSkippableBlocksCoveredByMaterial();
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!evt.player.field_70170_p.field_72995_K) {
            StructureTemplateManager.onPlayerConnect((EntityPlayerMP)evt.player);
        }
    }

    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        CapabilityRespawnData.onAttach(event);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)OneShotEntityDespawnListener.INSTANCE);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandStructure());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent evt) {
        if (AWStructureStatics.enableWorldGen) {
            WorldGenTickHandler.INSTANCE.finalTick();
        }
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
    }
}

