/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.block.WoodVariant;
import net.shadowmage.ancientwarfare.structure.render.property.StructureProperties;
import net.shadowmage.ancientwarfare.structure.util.BlockStateProperties;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;
import net.shadowmage.ancientwarfare.structure.util.WoodVariantHelper;

public class BlockBench
extends BlockSeat {
    private static final PropertyEnum<Legs> LEGS = PropertyEnum.func_177709_a((String)"legs", Legs.class);
    private static final Vec3d SEAT_OFFSET = new Vec3d(0.5, 0.35, 0.5);

    public BlockBench() {
        super(Material.field_151575_d, "bench");
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        WoodVariantHelper.getSubBlocks(this, items);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        EnumFacing.Axis perpendicularAxis = placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        world.func_175656_a(pos, state.func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariantHelper.getVariant(stack))).func_177226_a(StructureProperties.AXIS, (Comparable)perpendicularAxis));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WoodVariantHelper.getPickBlock(this, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperties.VARIANT, StructureProperties.AXIS, LEGS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariant.byMeta(meta & 7))).func_177226_a(StructureProperties.AXIS, (Comparable)((meta >> 3 & 1) > 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public int func_176201_c(IBlockState state) {
        return ((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT))).getMeta() | (state.func_177229_b(StructureProperties.AXIS) == EnumFacing.Axis.Z ? 1 : 0) << 3;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(StructureProperties.AXIS);
        Legs legs = Legs.NONE;
        if (axis == EnumFacing.Axis.X) {
            boolean west = this.isSameAxisBench(state, world, pos.func_177976_e());
            boolean east = this.isSameAxisBench(state, world, pos.func_177974_f());
            if (west && !east) {
                legs = Legs.LEFT;
            } else if (!west && east) {
                legs = Legs.RIGHT;
            } else if (!west) {
                legs = Legs.BOTH;
            }
        } else {
            boolean south = this.isSameAxisBench(state, world, pos.func_177968_d());
            boolean north = this.isSameAxisBench(state, world, pos.func_177978_c());
            if (north && !south) {
                legs = Legs.RIGHT;
            } else if (!north && south) {
                legs = Legs.LEFT;
            } else if (!north) {
                legs = Legs.BOTH;
            }
        }
        return state.func_177226_a(LEGS, (Comparable)((Object)legs));
    }

    private boolean isSameAxisBench(IBlockState thisState, IBlockAccess world, BlockPos neighborPos) {
        IBlockState neighborState = world.func_180495_p(neighborPos);
        return neighborState.func_177230_c() == this && thisState.func_177229_b(StructureProperties.AXIS) == neighborState.func_177229_b(StructureProperties.AXIS);
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return RotationLimit.NO_LIMIT;
    }

    @Override
    protected Vec3d getSeatOffset() {
        return SEAT_OFFSET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        WoodVariantHelper.registerClient(this, propString -> "axis=x,legs=both," + propString);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(StructureProperties.AXIS) == EnumFacing.Axis.X ? new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.5625, 0.8125) : new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.5625, 1.0);
    }

    public static enum Legs implements IStringSerializable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right"),
        BOTH("both");

        private String name;

        private Legs(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

