/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;

public abstract class BlockMulti<T extends TileMulti>
extends BlockBaseStructure {
    public static final PropertyBool INVISIBLE = PropertyBool.func_177716_a((String)"invisible");
    private final Supplier<T> instantiateTe;
    private final Class<T> teClass;

    public BlockMulti(Material material, String regName, Supplier<T> instantiateTe, Class<T> teClass) {
        super(material, regName);
        this.instantiateTe = instantiateTe;
        this.teClass = teClass;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (TileEntity)this.instantiateTe.get();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INVISIBLE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INVISIBLE) != false ? 1 : 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        WorldTools.getTile((IBlockAccess)world, pos, this.teClass).ifPresent(te -> {
            this.setPlacementProperties(world, pos, placer, stack, te);
            te.setPlacementDirection(world, pos, state, placer.func_174811_aO(), placer.field_70177_z);
            this.placeInvisibleBlocks(world, state, te);
            te.setMainPosOnAdditionalBlocks();
        });
    }

    private void placeInvisibleBlocks(World world, IBlockState state, T te) {
        ((TileMulti)te).getAdditionalPositions(state).forEach(additionalPos -> world.func_175656_a(additionalPos, this.func_176223_P().func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf(true))));
    }

    protected abstract void setPlacementProperties(World var1, BlockPos var2, EntityLivingBase var3, ItemStack var4, T var5);
}

