/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public class BlockWoodenThrone
extends BlockSeat {
    private static final Map<EnumFacing, AxisAlignedBB> TOP_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final Map<EnumFacing, AxisAlignedBB> BOTTOM_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 1.0), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.9375), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 1.0, 1.0), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 1.0, 1.0));

    public BlockWoodenThrone() {
        super(Material.field_151575_d, "wooden_throne");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, CoreProperties.VISIBLE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf((meta >> 2 & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? 1 : 0) << 2;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? EnumBlockRenderType.MODEL : EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? BOTTOM_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)) : TOP_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos, state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return stateDown.func_177230_c().func_180639_a(world, pos.func_177977_b(), stateDown, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return new RotationLimit.FacingQuarter((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPos otherPos;
        BlockPos blockPos = otherPos = (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? pos.func_177984_a() : pos.func_177977_b();
        if (!world.func_175623_d(otherPos)) {
            world.func_175698_g(otherPos);
        }
        super.func_180663_b(world, pos, state);
    }
}

