/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.command;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.shadowmage.ancientwarfare.core.command.ISubCommand;
import net.shadowmage.ancientwarfare.core.command.ParentCommand;
import net.shadowmage.ancientwarfare.core.command.SimpleSubCommand;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateLoader;
import net.shadowmage.ancientwarfare.structure.tile.ScannerTracker;

public class CommandStructure
extends ParentCommand {
    public CommandStructure() {
        this.registerSubCommand(new DeleteCommand());
        this.registerSubCommand(new BuildCommand());
        this.registerSubCommand(new SaveCommand());
        this.registerSubCommand(new SimpleSubCommand("reload", (server, sender, args) -> {
            WorldGenStructureManager.INSTANCE.loadBiomeList();
            TemplateLoader.INSTANCE.reloadAll();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.reloaded", new Object[0]));
        }));
        this.registerSubCommand(new ReexportCommand());
        this.registerSubCommand(new SimpleSubCommand("scannerTp", (server, sender, args) -> {
            if (args.length == 1 && sender instanceof EntityPlayer) {
                Tuple<Integer, BlockPos> pos = ScannerTracker.getScannerPosByName(args[0]);
                ScannerTracker.teleportAboveScannerBlock((EntityPlayer)sender, pos);
            }
        }){

            @Override
            public int getMaxArgs() {
                return 1;
            }
        });
        this.registerSubCommand(new SimpleSubCommand("name", (server, sender, args) -> {
            Optional<StructureEntry> structure = AWGameData.INSTANCE.getData(sender.func_130014_f_(), StructureMap.class).getStructureAt(sender.func_130014_f_(), sender.func_180425_c());
            sender.func_145747_a((ITextComponent)structure.map(structureEntry -> new TextComponentTranslation("command.aw.structure.name", new Object[]{structureEntry.getName()})).orElseGet(() -> new TextComponentTranslation("command.aw.structure.no_structure", new Object[0])));
        }));
    }

    public String func_71517_b() {
        return "awstructure";
    }

    public String func_71518_a(ICommandSender var1) {
        return "command.aw.structure.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return super.func_184883_a(server, sender, args, targetPos);
        }
        if (args.length > 5 && args[0].equalsIgnoreCase("build")) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"north", "east", "south", "west"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("scannertp")) {
            return CommandBase.func_71530_a((String[])args, (String[])ScannerTracker.getTrackedScannerNames().toArray(new String[0]));
        }
        return Collections.emptyList();
    }

    private class ReexportCommand
    implements ISubCommand {
        private ReexportCommand() {
        }

        @Override
        public String getName() {
            return "scannersReexport";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (sender instanceof EntityPlayer) {
                boolean reloadMainSettings = false;
                if (args.length == 1) {
                    reloadMainSettings = Boolean.valueOf(args[0]);
                }
                ScannerTracker.reexportAll((EntityPlayer)sender, reloadMainSettings);
            }
        }

        @Override
        public int getMaxArgs() {
            return 1;
        }
    }

    private class DeleteCommand
    implements ISubCommand {
        private DeleteCommand() {
        }

        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] subArgs) throws CommandException {
            if (subArgs.length < 1) {
                throw new WrongUsageException(CommandStructure.this.func_71518_a(sender), new Object[0]);
            }
            String name = subArgs[0];
            boolean flag = StructureTemplateManager.removeTemplate(name);
            if (flag) {
                boolean shouldDelete;
                TextComponentTranslation txt = new TextComponentTranslation("command.aw.structure.template_removed", new Object[]{name});
                sender.func_145747_a((ITextComponent)txt);
                if (subArgs.length > 1 && (shouldDelete = subArgs[1].equalsIgnoreCase("true"))) {
                    txt = this.deleteTemplateFile(name) ? new TextComponentTranslation("command.aw.structure.file_deleted", new Object[]{name}) : new TextComponentTranslation("command.aw.structure.file_not_found", new Object[]{name});
                    sender.func_145747_a((ITextComponent)txt);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.not_found", new Object[]{name}));
            }
        }

        private boolean deleteTemplateFile(String name) {
            String path = "config/ancientwarfare/structures/included/" + name + "." + AWStructureStatics.templateExtension;
            File file = new File(path);
            if (file.exists()) {
                file.delete();
                return true;
            }
            return false;
        }

        @Override
        public int getMaxArgs() {
            return 2;
        }
    }

    private class BuildCommand
    implements ISubCommand {
        private BuildCommand() {
        }

        @Override
        public String getName() {
            return "build";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] subArgs) throws CommandException {
            Optional<StructureTemplate> template;
            if (subArgs.length < 4) {
                throw new WrongUsageException(CommandStructure.this.func_71518_a(sender), new Object[0]);
            }
            int x = CommandBase.func_175755_a((String)subArgs[1]);
            int y = CommandBase.func_175755_a((String)subArgs[2]);
            int z = CommandBase.func_175755_a((String)subArgs[3]);
            EnumFacing face = EnumFacing.SOUTH;
            if (subArgs.length > 4) {
                face = EnumFacing.func_176739_a((String)subArgs[4]);
            }
            if ((template = StructureTemplateManager.getTemplate(subArgs[0])).isPresent()) {
                StructureBuilder builder = new StructureBuilder(sender.func_130014_f_(), template.get(), face, new BlockPos(x, y, z));
                builder.instantConstruction();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.built", new Object[]{subArgs[0], x, y, z}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.not_found", new Object[]{subArgs[0]}));
            }
        }

        @Override
        public int getMaxArgs() {
            return 5;
        }
    }

    private class SaveCommand
    implements ISubCommand {
        private SaveCommand() {
        }

        @Override
        public String getName() {
            return "save";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] subArgs) throws CommandException {
            ItemStack stack;
            if (sender instanceof EntityLivingBase && !(stack = ((EntityLivingBase)sender).func_184614_ca()).func_190926_b()) {
                ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
                if (settings.hasPos1() && settings.hasPos2() && settings.hasBuildKey() && (settings.hasName() || subArgs.length > 0)) {
                    String name = settings.hasName() ? settings.name() : subArgs[0];
                    ItemStructureScanner.setStructureName(stack, name);
                    if (ItemStructureScanner.scanStructure(sender.func_130014_f_(), stack)) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.exported", new Object[]{subArgs[0]}));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.structure.incomplete_data", new Object[0]));
                }
            }
        }

        @Override
        public int getMaxArgs() {
            return 1;
        }
    }
}

