/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;

public class AWStructureStatics
extends ModConfiguration {
    public static Set<String> lootTableExclusions;
    public static String templateExtension;
    public static String townTemplateExtension;
    public static boolean enableWorldGen;
    public static boolean enableTownGeneration;
    public static boolean enableStructureGeneration;
    public static boolean loadDefaultPack;
    public static int clusterValueSearchRange;
    public static int duplicateStructureSearchRange;
    public static int maxClusterValue;
    public static float randomGenerationChance;
    public static int spawnProtectionRange;
    public static int townClosestDistance;
    public static float townGenerationChance;
    public static Set<String> excludedSpawnerEntities;
    private static HashSet<String> skippableWorldGenBlocks;
    private static HashSet<String> worldGenTargetBlocks;
    private static HashSet<String> scannerSkippedBlocks;
    private static final String worldGenCategory = "a_world-gen_settings";
    private static final String villageGenCategory = "b_village-gen_settings";
    private static final String excludedEntitiesCategory = "c_excluded_spawner_entities";
    private static final String worldGenBlocks = "d_world_gen_skippable_blocks";
    private static final String targetBlocks = "e_world_gen_target_blocks";
    private static final String scanSkippedBlocks = "f_scanner_skipped_blocks";
    private static final String excludedLootTables = "g_excluded_loot_tables";

    public AWStructureStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment(worldGenCategory, "Settings that effect all world-structure-generation.");
        this.config.addCustomCategoryComment(villageGenCategory, "Settings that effect the generation of vanilla villages.\nCurrently there are no village-generation options, and no structures will generate in villages.");
        this.config.addCustomCategoryComment(excludedEntitiesCategory, "Entities that will not show up in the Mob Spawner Placer entity selection list.\nAdd any mobs here that will crash if spawned via the vanilla mob-spawner (usually complex NBT-defined entities).");
        this.config.addCustomCategoryComment(worldGenBlocks, "Blocks that should be skipped/ignored during world gen -- should list all plant blocks/logs/foliage");
        this.config.addCustomCategoryComment(targetBlocks, "List of target blocks that structures and towns can spawn on in addition to materials that are automatically whitelisted.");
        this.config.addCustomCategoryComment(scanSkippedBlocks, "List of blocks that the structure scanner will completely ignore.\nWhenever these blocks are encountered the template will instead fill that block position with a hard-air rule.\nAdd any blocks to this list that may cause crashes when scanned or duplicated.\nVanilla blocks should not need to be added, but some mod-blocks may.\nBlock names must be specified by fully-qualified name (e.g. \"minecraft:chests/stronghold_corridor\")");
        this.config.addCustomCategoryComment(excludedLootTables, "List of loot tables that should be excluded from loot chest placer GUI.\nLoot table names must be specified by fully-qualified name (e.g. \"minecraft:stone\")");
    }

    @Override
    protected void initializeValues() {
        templateExtension = this.config.get(worldGenCategory, "template_extension", "aws", "Default=" + templateExtension + "\nThe template extension used when looking for and exporting templates.\nOnly files matching this extension will be examined.").getString();
        enableStructureGeneration = this.config.get(worldGenCategory, "enable_structure_generation", enableStructureGeneration, "Default=" + enableStructureGeneration + "\nEnable or disable structure (not town) generation.").getBoolean(enableStructureGeneration);
        enableTownGeneration = this.config.get(worldGenCategory, "enable_town_generation", enableTownGeneration, "Default=" + enableTownGeneration + "\nEnable or disable custom town generation e.g. walls and additional buildings.").getBoolean(enableTownGeneration);
        loadDefaultPack = this.config.get(worldGenCategory, "load_default_structure_pack", loadDefaultPack, "If true the default structure pack will be loaded and enabled for world-gen.").getBoolean(loadDefaultPack);
        duplicateStructureSearchRange = this.config.get(worldGenCategory, "validation_duplicate_search_radius", duplicateStructureSearchRange, "Default=" + duplicateStructureSearchRange + "\nThe minimum radius in chunks to be searched for duplicate structures.\nThis setting should generally not need to be adjusted unless you have templates with extremely\nlarge 'minDuplicateDistance' values\nExtremely large values may introduce extra lag during generation.  Lower values may reduce lag during generation,\nat the cost of some accuracy in the min duplicate distance tests.").getInt(duplicateStructureSearchRange);
        clusterValueSearchRange = this.config.get(worldGenCategory, "validation_cluster_value_search_radius", clusterValueSearchRange, "Default=" + clusterValueSearchRange + "\nThe minimum radius in chunks to be searched for structures when tallying cluster value in an area.\nThis setting should be adjusted along with maxClusterValue and the clusterValue in templates to encourage\nor discourage specific structures to generate near eachother.\nExtremely large values may introduce extra lag during generation.  Lower values may reduce lag during generation,\nat the cost of some accuracy in the cluster value tests.").getInt(clusterValueSearchRange);
        maxClusterValue = this.config.get(worldGenCategory, "max_cluster_value", maxClusterValue, "Default=" + maxClusterValue + "\nThe maximum allowed cluster value that may be present inside of 'validation_chunk_radius'.\n").getInt(maxClusterValue);
        randomGenerationChance = (float)this.config.get(worldGenCategory, "random_generation_chance", (double)randomGenerationChance, "Default=" + randomGenerationChance + "\nAccepts values between 0 and 1.\nDetermines the chance that a structure will attempt to be generated in any given chunk.\nNumber is specified as a percentage -- e.g. 0.75 == 75% chance to attempt generation.\nHigher values will result in more attempts to generate structures.  Actual number\ngenerated will depend upon your specific templates and their validation settings.\nValues of 0 or lower will result in no structures generating.  Values higher than 1\nwill result in a generation attempt in every chunk.").getDouble((double)randomGenerationChance);
        spawnProtectionRange = this.config.get(worldGenCategory, "spawn_protection_chunk_radius", spawnProtectionRange, "Default=" + spawnProtectionRange + "\nDetermines the area around the central spawn coordinate that will be excluded from random structure generation.\nLarger values will see a larger area around spawn that is devoid of structures.").getInt(spawnProtectionRange);
        enableWorldGen = this.config.get("02_server_settings", "enable_world_generation", enableWorldGen, "Default=" + enableWorldGen + "\nEnable or disable world generation entirely. If disabled, all other options will have no effect.").getBoolean(enableWorldGen);
        townClosestDistance = this.config.get(worldGenCategory, "town_min_distance", townClosestDistance, "Default=" + townClosestDistance + "\nMinimum distance between towns.  This should be set to a value quite a bit larger than the largest townthat you have configured for generation.  E.G.  Max town size=16, this value should be >= 40.").getInt(townClosestDistance);
        townGenerationChance = (float)this.config.get(worldGenCategory, "town_generation_chance", (double)townGenerationChance, "Default=" + townGenerationChance + "\nAccepts values between 0 and 1.0.  Decimal percent chance to -attempt- town generation for any given chunk.  Higher settings may result inmore towns being generated, but may come with a performance hit during new chunk generation.  Lower values WILL result in fewer towns, and-may- improve performance during chunk generation.").getDouble((double)townGenerationChance);
        this.initializeDefaultSkippableBlocks();
        this.initializeDefaultSkippedEntities();
        this.initializeDefaultTargetBlocks();
        this.initializeScannerSkippedBlocks();
        lootTableExclusions = new HashSet<String>(Arrays.asList(this.config.get(excludedLootTables, "excluded_loot_tables", new String[]{"primitivemobs:entities/chameleon", "minecraft:entities/ocelot", "minecraft:entities/silverfish", "minecraft:entities/llama", "twilightforest:entities/death_tome_hurt", "twilightforest:entities/yeti", "twilightforest:entities/mini_ghast", "twilightforest:entities/snow_guardian", "minecraft:entities/sheep/brown", "minecraft:entities/vex", "minecraft:entities/elder_guardian", "minecolonies:entityarcherbarbariandrops", "minecraft:entities/creeper", "primitivemobs:entities/mimic", "primitivemobs:entities/lily_lurker", "minecraft:entities/sheep/red", "twilightforest:entities/questing_ram_rewards", "twilightforest:entities/fire_beetle", "twilightforest:entities/redcap", "minecraft:entities/horse", "minecraft:entities/slime", "twilightforest:entities/bunny", "minecraft:entities/ghast", "minecraft:entities/zombie", "exoticbirds:birds/woodpecker", "minecraft:entities/sheep/silver", "twilightforest:entities/ice_crystal", "minecraft:entities/mushroom_cow", "minecolonies:entitychiefbarbariandrops", "exoticbirds:birds/toucan", "minecraft:entities/sheep/white", "exoticbirds:birds/hummingbird", "exoticbirds:birds/bluejay", "exoticbirds:birds/roadrunner", "minecraft:entities/sheep/cyan", "minecraft:entities/zombie_pigman", "minecraft:entities/cow", "minecraft:entities/pig", "exoticbirds:birds/heron", "exoticbirds:birds/peahen", "exoticbirds:birds/peacock", "exoticbirds:birds/cardinal", "exoticbirds:birds/duck", "exoticbirds:birds/ostrich", "minecraft:entities/stray", "exoticbirds:birds/gouldianfinch", "minecraft:entities/sheep/magenta", "exoticbirds:birds/cassowary", "primitivemobs:entities/blazing_juggernaut", "minecraft:gameplay/fishing/fish", "twilightforest:entities/winter_wolf", "minecraft:gameplay/fishing/junk", "minecraft:entities/donkey", "twilightforest:entities/tower_termite", "twilightforest:entities/goblin_knight", "exoticbirds:birds/kiwi", "ebwizardry:entities/evil_wizard", "exoticbirds:dungeon_phoenix", "minecraft:entities/villager", "minecraft:entities/spider", "twilightforest:entities/ice_exploder", "exoticbirds:birds/seagull", "minecraft:entities/zombie_horse", "minecraft:entities/sheep/yellow", "minecraft:entities/sheep/black", "primitivemobs:chests/mimic_trap", "twilightforest:entities/hydra", "exoticbirds:birds/pigeon", "twilightforest:entities/minoshroom", "minecraft:entities/magma_cube", "minecraft:entities/sheep/pink", "twilightforest:entities/death_tome", "minecraft:entities/mule", "familiarfauna:entities/butterfly", "twilightforest:entities/armored_giant", "minecraft:entities/endermite", "minecraft:entities/bat", "minecraft:gameplay/fishing", "familiarfauna:entities/turkey", "silentgems:ender_slime", "primitivemobs:entities/festive_creeper", "exoticbirds:birds/kingfisher", "minecraft:entities/evocation_illager", "primitivemobs:entities/special/filch_lizard_steal", "minecraft:entities/witch", "minecraft:entities/skeleton_horse", "minecraft:entities/zombie_villager", "twilightforest:entities/ice_shooter", "twilightforest:entities/block_goblin", "exoticbirds:birds/kookaburra", "minecraft:entities/guardian", "primitivemobs:entities/special/haunted_tool", "twilightforest:entities/wraith", "familiarfauna:entities/snail", "minecraft:entities/blaze", "minecraft:entities/sheep", "minecraft:entities/sheep/orange", "exoticbirds:birds/owl", "twilightforest:entities/snow_queen", "twilightforest:entities/minotaur", "twilightforest:entities/yeti_alpha", "exoticbirds:birds/crane", "minecraft:entities/sheep/lime", "twilightforest:entities/naga", "exoticbirds:birds/swan", "minecraft:empty", "exoticbirds:birds/parrot", "exoticbirds:birds/flamingo", "primitivemobs:entities/rocket_creeper", "familiarfauna:entities/deer", "twilightforest:entities/raven", "minecraft:entities/chicken", "twilightforest:entities/giant_miner", "minecolonies:entitybarbariandrops", "exoticbirds:birds/vulture", "twilightforest:entities/skeleton_druid", "exoticbirds:birds/penguin", "familiarfauna:entities/pixie", "minecraft:entities/sheep/light_blue", "minecraft:entities/wolf", "minecraft:entities/skeleton", "primitivemobs:entities/support_creeper", "minecraft:entities/enderman", "primitivemobs:entities/dodo", "minecraft:entities/squid", "minecraft:entities/shulker", "twilightforest:entities/deer", "twilightforest:entities/troll", "exoticbirds:birds/pelican", "minecraft:entities/cave_spider", "minecraft:entities/sheep/green", "twilightforest:entities/tower_golem", "minecraft:entities/wither_skeleton", "minecraft:entities/snowman", "minecraft:entities/sheep/blue", "familiarfauna:entities/dragonfly", "minecraft:entities/rabbit", "twilightforest:entities/helmet_crab", "twilightforest:entities/bird", "twilightforest:entities/slime_beetle", "twilightforest:entities/maze_slime", "minecraft:entities/polar_bear", "minecraft:entities/ender_dragon", "twilightforest:entities/kobold", "exoticbirds:birds/phoenix", "minecraft:entities/parrot", "minecraft:entities/sheep/gray", "twilightforest:entities/lich", "exoticbirds:birds/lyrebird", "exoticbirds:birds/booby", "minecraft:entities/vindication_illager", "exoticbirds:birds/magpie", "minecraft:entities/husk", "minecraft:entities/sheep/purple", "minecraft:entities/giant", "primitivemobs:entities/special/filch_lizard_spawn", "minecraft:entities/iron_golem"}).getStringList()));
    }

    private void initializeScannerSkippedBlocks() {
        String[] defaultSkippableBlocks = new String[]{"AncientWarfareStructure:gate_proxy"};
        defaultSkippableBlocks = this.config.getStringList("scanner_skipped_blocks", scanSkippedBlocks, defaultSkippableBlocks, "Blocks TO be skipped by structure scanner");
        Collections.addAll(scannerSkippedBlocks, defaultSkippableBlocks);
    }

    private void initializeDefaultSkippableBlocks() {
        String[] defaultSkippableBlocks = new String[]{"betterunderground:blockdecorations", "betterunderground:blockfossils", "betterunderground:blockfossils", "betterunderground:blocksandstonestalactite", "betterunderground:blocksandstonestalactite", "betterunderground:blockstonestalactite", "betterunderground:blockstonestalactite", "betterunderground:mossydirt", "betterunderground:mossydirt", "biomesoplenty:coral", "biomesoplenty:gem_block", "biomesoplenty:gem_ore", "biomesoplenty:hot_spring_water", "biomesoplenty:seaweed", "chancecubes:chance_cube", "coralreef:coral", "coralreef:reef", "dungeonmobs:bladetrap", "dungeontactics:ore_enddiamond", "dungeontactics:ore_endlapis", "dungeontactics:ore_stonequartz", "ebwizardry:crystal_ore", "ebwizardry:petrified_stone", "floricraft:leaves_christmas", "floricraft:leaves_christmas_dynamic", "floricraft:leaves_christmas_dynamic_unlit", "floricraft:leaves_christmas_unlit", "floricraft:leaves_floric_type0", "floricraft:ornament_christmas", "floricraft:sapling_christmas", "floricraft:sapling_floric_type0", "forestry:apiary", "forestry:leaves", "forestry:leaves.decorative.0", "forestry:leaves.decorative.1", "forestry:leaves.decorative.2", "forestry:leaves.default.0", "forestry:leaves.default.1", "forestry:leaves.default.2", "forestry:leaves.default.3", "forestry:leaves.default.4", "forestry:leaves.default.5", "forestry:leaves.default.6", "forestry:leaves.default.7", "forestry:leaves.default.8", "forestry:logs.0", "forestry:logs.1", "forestry:logs.2", "forestry:logs.3", "forestry:logs.4", "forestry:logs.5", "forestry:logs.6", "forestry:logs.7", "forestry:mushroom", "forestry:stump", "gravestone:gsgravestone", "gravestone-extended:gstrap", "grimoireofgaia:web_temp", "harvestcraft:aridgarden", "harvestcraft:frostgarden", "harvestcraft:shadedgarden", "harvestcraft:soggygarden", "harvestcraft:tropicalgarden", "harvestcraft:windygarden", "iceandfire:fire_lily", "iceandfire:frost_lily", "minecraft:lava", "minecraft:snow_layer", "minecraft:sponge", "minecraft:web", "mocreatures:mocleaves", "mocreatures:moclog", "mocreatures:moctallgrass", "silentgems:chaosnode", "silentgems:essenceore", "silentgems:gemblockdark", "silentgems:gemglassdark", "silentgems:gemlamp", "silentgems:gemore", "silentgems:gemoredark", "silentgems:gemorelight", "silentgems:multi_gem_ore_classic", "silentgems:multi_gem_ore_dark", "silentgems:multi_gem_ore_light", "silentgems:teleporter", "wizardry:torikki_grass", "wizardry:wisdom_leaves", "wizardry:wisdom_wood_log", "zawa:arctic_moss", "zawa:bamboo", "zawa:beeplant", "zawa:bellflowers", "zawa:bladderwrack", "zawa:brain_coral", "zawa:bromeliad", "zawa:cinnamon_fern", "zawa:elegance_coral", "zawa:fan_palm_bottom", "zawa:fan_palm_top", "zawa:fire_coral", "zawa:golden_barrel_cactus", "zawa:gracilaria", "zawa:kelp", "zawa:large_sea_anemone", "zawa:large_sea_urchin", "zawa:lettuce_coral", "zawa:mixed_coral_plates", "zawa:mixed_coral_rocks", "zawa:mixed_stone", "zawa:mixed_stone_mossy", "zawa:ostritch_fern", "zawa:peach_flower", "zawa:peach_flower", "zawa:river_stone", "zawa:sea_grass", "zawa:sea_urchin_tropical", "zawa:small_sea_anemone", "zawa:small_sea_urchin", "zawa:staghorn_coral", "zawa:stonecrop", "zawa:wild_celery", "zoocraftdiscoveries:arcticpine_log", "zoocraftdiscoveries:cookie_bush", "zoocraftdiscoveries:herbs_basil", "zoocraftdiscoveries:herbs_bay", "zoocraftdiscoveries:herbs_chive", "zoocraftdiscoveries:herbs_coriander", "zoocraftdiscoveries:herbs_dill", "zoocraftdiscoveries:herbs_lemongrass", "zoocraftdiscoveries:herbs_mint", "zoocraftdiscoveries:herbs_oregano", "zoocraftdiscoveries:herbs_parsley", "zoocraftdiscoveries:herbs_rosemary", "zoocraftdiscoveries:herbs_saffron", "zoocraftdiscoveries:herbs_sage", "zoocraftdiscoveries:herbs_tarragon", "zoocraftdiscoveries:herbs_thyme"};
        defaultSkippableBlocks = this.config.get(worldGenBlocks, "skippable_blocks", defaultSkippableBlocks).getStringList();
        Collections.addAll(skippableWorldGenBlocks, defaultSkippableBlocks);
    }

    public static void logSkippableBlocksCoveredByMaterial() {
        skippableWorldGenBlocks.stream().filter(b -> AWStructureStatics.getBlock(b).isPresent() && AWStructureStatics.isSkippableMaterial(AWStructureStatics.getBlock(b).get().func_176223_P().func_185904_a())).forEach(b -> AncientWarfareStructure.LOG.info("Block {} defined as skippable is redundant as its material is already skipped by default", b));
    }

    private static Optional<Block> getBlock(String registryName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
        return block == Blocks.field_150350_a ? Optional.empty() : Optional.ofNullable(block);
    }

    private void initializeDefaultSkippedEntities() {
        String[] defaultExcludedEntities = new String[]{"ancientwarfarestructure:aw_gate", "Arrow", "awger_Hoy.EntityHoy", "awer_Punt.EntityPunt", "awger_SmallBoat.EntityBoatChest", "awger_SmallBoat.EntityBoatPart", "awger_SmallBoat.EntitySmallBoat", "awger_Whitehall.EntityWhitehall", "BiblioCraft.SeatEntity", "BiomesOPlenty.dart", "BiomesOPlenty.mudball", "BiomesOPlenty.PoisonDart", "BladeTrap", "Boat", "Cannon", "cfm.MountableBlock", "chocolateQuest.Beam", "chocolateQuest.ChocoProjectile", "chocolateQuest.CQ_npc", "chocolateQuest.dummy", "chocolateQuest.EntityPart", "chocolateQuest.EntityPartRidable", "chocolateQuest.EntityPartSlime", "chocolateQuest.Hookshoot", "CustomNpcChairMount", "DemonMobs.DemonicBlast", "DemonMobs.DemonicSpark", "DemonMobs.Doomfireball", "DemonMobs.Hellfireball", "DesertMobs.Mudshot", "DesertMobs.ThrowingScythe", "EnderCrystal", "EnderDragon", "ExtrabiomesXL.scarecrow", "EyeOfEnderSignal", "EyeRay", "FallingSand", "Fireball", "FireworksRocketEntity", "goblin.Arcaneball", "goblin.Bomb", "goblin.ETNTPrimed", "goblin.GArcanebal", "goblin.Lightball", "goblin.MTNTPrimed", "goblin.orbB", "goblin.orbG", "goblin.orbR", "goblin.orbY", "hoy.Hoy", "Item", "ItemFrame", "JungleMobs.ConcapedeSegment", "KoadPirates.Cannon Ball", "KoadPirates.Net", "KoadPirates.Shot", "KoadPirates.Tether", "LeashKnot", "lom_DirtPile", "lotr.Banner", "lotr.Barrel", "lotr.Conker", "lotr.CrossbowBolt", "lotr.GandalfFireball", "lotr.InvasionSpawner", "lotr.LOTRTNT", "lotr.MysteryWeb", "lotr.OrcBomb", "lotr.Pebble", "lotr.Plate", "lotr.Portal", "lotr.SmokeRing", "lotr.Spear", "lotr.ThrowingAxe", "lotr.ThrownRock", "lotr.ThrownTermite", "lotr.TraderRespawn", "lotr.WallBanner", "lotr.WargRug", "MagicMissile", "mam.firebreath", "mam.goldarrow", "mam.kitsune", "mam.music", "mam.stick", "Metallurgy3Base.LargeTNTEntity", "Metallurgy3Base.MinersTNTEntity", "MinecartChest", "MinecartCommandBlock", "MinecartFurnace", "MinecartHopper", "MinecartRideable", "MinecartSpawner", "MinecartTNT", "minecolonies.arrow", "minecolonies.baker", "minecolonies.blacksmith", "minecolonies.builder", "minecolonies.citizen", "minecolonies.deliveryman", "minecolonies.farmer", "minecolonies.huntersdog", "minecolonies.miner", "minecolonies.pointer", "minecolonies.soldier", "minecolonies.stonemason", "minecolonies.stonemason", "Mob", "MoCreatures.Egg", "MoCreatures.FishBowl", "MoCreatures.KittyBed", "MoCreatures.LitterBox", "MoCreatures.MoCPlatform", "MoCreatures.PetScorpion", "MoCreatures.TRock", "Monster", "npccrystal", "NpcDragon", "npcdwarffemale", "npcdwarfmale", "npcelffemale", "npcelfmale", "npcenderchibi", "npcEnderman", "npcfurryfemale", "npcfurrymale", "npcGolem", "npchumanfemale", "npchumanmale", "npcnagafemale", "npcnagamale", "npcorcfemale", "npcorcmale", "npcpony", "npcskeleton", "NpcSlime", "npcvillager", "npczombiefemale", "npczombiemale", "Painting", "Paleocraft.Bladeking68", "Petrified", "PrimedTnt", "primitivemobs.Ball", "primitivemobs.Lily", "primitivemobs.SpawnEgg", "ProjectZulu|Core.CreeperBlossomPrimed", "ProjectZulu|Core.DuckEgg", "ProjectZulu|Core.Follower", "ProjectZulu|Core.Lizard Spit", "ProjectZulu|Core.OstrichEgg", "ProjectZulu|Core.ThrowingRock", "punt.Punt", "RakshasaImage", "RopesPlus.ConfusingArrow", "RopesPlus.DirtArrow", "RopesPlus.ExplodingArrow", "RopesPlus.FireArrow", "RopesPlus.FreeFormRope", "RopesPlus.FrostArrow", "RopesPlus.GrapplingHook", "RopesPlus.PenetratingArrow", "RopesPlus.RedstonetorchArrow", "RopesPlus.RopeArrow", "RopesPlus.SeedArrow", "RopesPlus.SlimeArrow", "RopesPlus.TorchArrow", "RopesPlus.WarpArrow", "smallboats.EntityBoatChest", "smallboats.EntityBoatGun", "smallboats.EntityBoatPart", "smallboats.EntitySmallBoat", "SmallFireball", "Snowball", "SonicBoom", "SwampMobs.PoisonRay", "SwampMobs.PoisonRayEnd", "SwampMobs.VenomShot", "throwableitem", "ThrownEnderpearl", "ThrownExpBottle", "ThrownPotion", "TwilightForest.tffallingice", "TwilightForest.tflichbolt", "TwilightForest.tflichbomb", "TwilightForest.tfmoonwormshot", "TwilightForest.tfthrownaxe", "TwilightForest.tfthrownice", "TwilightForest.tfthrownpick", "TwilightForest.tfcharmeffect", "TwilightForest.tfhydramortar", "TwilightForest.tfnaturebolt", "TwilightForest.tfslimeblob", "TwilightForest.tftomebolt", "TwilightForest.tftwilightwandbolt", "weaponmod.bolt", "weaponmod.boomerang", "weaponmod.bullet", "weaponmod.cannon", "weaponmod.cannonball", "weaponmod.dart", "weaponmod.dummy", "weaponmod.dynamite", "weaponmod.flail", "weaponmod.javelin", "weaponmod.knife", "weaponmod.shot", "weaponmod.spear", "witchery.bolt", "witchery.brew", "witchery.broom", "witchery.corpse", "witchery.eye", "witchery.familiar", "witchery.goblingulg", "witchery.illusionCreeper", "witchery.illusionSpider", "witchery.illusionZombie", "witchery.mandrake", "witchery.owl", "witchery.soulfire", "witchery.spellEffect", "witchery.spirit", "WitherBoss", "WitherSkull", "XPOrb"};
        defaultExcludedEntities = this.config.get(excludedEntitiesCategory, "excluded_entities", defaultExcludedEntities).getStringList();
        Collections.addAll(excludedSpawnerEntities, defaultExcludedEntities);
    }

    private void initializeDefaultTargetBlocks() {
        String[] defaultTargetBlocks = new String[]{"minecraft:snow", "minecraft:ice", "minecraft:water", "minecraft:clay", "minecraft:mycelium", "minecraft:stone", "minecraft:grass", "minecraft:dirt", "minecraft:sand", "minecraft:gravel", "minecraft:sand", "minecraft:sandstone", "BiomesOPlenty:mud", "BiomesOPlenty:driedDirt", "BiomesOPlenty:rocks", "BiomesOPlenty:ash", "BiomesOPlenty:ashStone", "BiomesOPlenty:hardSand", "BiomesOPlenty:hardDirt", "BiomesOPlenty:biomeBlock", "BiomesOPlenty:crystal", "BiomesOPlenty:gemOre", "BiomesOPlenty:cragRock", "mam:mam_mamgravel", "mam:mam_depthquartz", "mam:mam_depthquartzchiseled", "mam:mam_depthquartzlines", "mam:mam_depthcrystalblock"};
        defaultTargetBlocks = this.config.get("target_blocks", targetBlocks, defaultTargetBlocks, "List of blocks that are valid").getStringList();
        Collections.addAll(worldGenTargetBlocks, defaultTargetBlocks);
    }

    public static boolean isValidTargetBlock(IBlockState state) {
        return AWStructureStatics.isValidTargetMaterial(state.func_185904_a()) || worldGenTargetBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isValidTargetMaterial(Material material) {
        return material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151576_e || material == Material.field_151597_y || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151595_p || material == Material.field_151586_h;
    }

    public static boolean isSkippable(IBlockState state) {
        return AWStructureStatics.isSkippableMaterial(state.func_185904_a()) || skippableWorldGenBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isSkippableMaterial(Material material) {
        return material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151584_j || material == Material.field_151575_d || material == Material.field_151572_C || material == Material.field_151570_A;
    }

    public static boolean shouldSkipScan(Block block) {
        return scannerSkippedBlocks.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public static boolean withinProtectionRange(double dist) {
        return dist < (double)(spawnProtectionRange * spawnProtectionRange * 16 * 16);
    }

    static {
        templateExtension = "aws";
        townTemplateExtension = "awt";
        enableWorldGen = true;
        enableTownGeneration = true;
        enableStructureGeneration = true;
        loadDefaultPack = true;
        clusterValueSearchRange = 16;
        duplicateStructureSearchRange = 40;
        maxClusterValue = 500;
        randomGenerationChance = 0.075f;
        spawnProtectionRange = 12;
        townClosestDistance = 40;
        townGenerationChance = 0.125f;
        excludedSpawnerEntities = new HashSet<String>();
        skippableWorldGenBlocks = new HashSet();
        worldGenTargetBlocks = new HashSet();
        scannerSkippedBlocks = new HashSet();
    }
}

