/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedBase;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.item.ItemSpawnerPlacer;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class ContainerSpawnerAdvanced
extends ContainerSpawnerAdvancedBase {
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";

    public ContainerSpawnerAdvanced(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.settings = new SpawnerSettings();
        ItemStack item = EntityTools.getItemFromEitherHand(player, ItemBlockAdvancedSpawner.class);
        if (!item.func_190926_b()) {
            if (!item.func_77942_o() || !item.func_77978_p().func_74764_b(SPAWNER_SETTINGS_TAG)) {
                throw new IllegalArgumentException("stack must have correct data!!");
            }
            this.settings.readFromNBT(item.func_77978_p().func_74775_l(SPAWNER_SETTINGS_TAG));
        } else {
            item = EntityTools.getItemFromEitherHand(player, ItemSpawnerPlacer.class);
            if (!ItemSpawnerPlacer.hasSpawnerData(item)) {
                throw new IllegalArgumentException("stack must have correct data!!");
            }
            this.settings.readFromNBT(ItemSpawnerPlacer.getSpawnerData(item));
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(SPAWNER_SETTINGS_TAG)) {
            ItemStack item = EntityTools.getItemFromEitherHand(this.player, ItemBlockAdvancedSpawner.class);
            if (!item.func_190926_b()) {
                item.func_77983_a(SPAWNER_SETTINGS_TAG, (NBTBase)tag.func_74775_l(SPAWNER_SETTINGS_TAG));
            } else {
                item = EntityTools.getItemFromEitherHand(this.player, ItemSpawnerPlacer.class);
                ItemSpawnerPlacer.setSpawnerData(item, tag.func_74775_l(SPAWNER_SETTINGS_TAG));
            }
        }
    }
}

