/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedInventoryBase;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.item.ItemSpawnerPlacer;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class ContainerSpawnerAdvancedInventoryItem
extends ContainerSpawnerAdvancedInventoryBase {
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";

    public ContainerSpawnerAdvancedInventoryItem(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.settings = new SpawnerSettings();
        ItemStack item = EntityTools.getItemFromEitherHand(player, ItemBlockAdvancedSpawner.class);
        if (!item.func_190926_b()) {
            if (!item.func_77942_o() || !item.func_77978_p().func_74764_b(SPAWNER_SETTINGS_TAG)) {
                throw new IllegalArgumentException("stack must have correct data!!");
            }
            this.settings.readFromNBT(item.func_77978_p().func_74775_l(SPAWNER_SETTINGS_TAG));
        } else {
            item = EntityTools.getItemFromEitherHand(player, ItemSpawnerPlacer.class);
            if (!ItemSpawnerPlacer.hasSpawnerData(item)) {
                player.func_145747_a((ITextComponent)new TextComponentString("Must have an entity set first!"));
                this.settings.readFromNBT(ItemSpawnerPlacer.getSpawnerData(item));
            }
        }
        this.inventory = this.settings.getInventory();
        this.addSettingsInventorySlots();
        this.addPlayerSlots(8, 70, 8);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(SPAWNER_SETTINGS_TAG)) {
            ItemStack item = EntityTools.getItemFromEitherHand(this.player, ItemBlockAdvancedSpawner.class);
            if (!item.func_190926_b()) {
                item.func_77983_a(SPAWNER_SETTINGS_TAG, (NBTBase)tag.func_74775_l(SPAWNER_SETTINGS_TAG));
            } else {
                item = EntityTools.getItemFromEitherHand(this.player, ItemSpawnerPlacer.class);
                ItemSpawnerPlacer.setSpawnerData(item, tag.func_74775_l(SPAWNER_SETTINGS_TAG));
            }
        }
    }
}

