/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.item.ItemTownBuilder;

public class ContainerTownSelection
extends ContainerBase {
    public String townName;
    private int width;
    private int length;

    public ContainerTownSelection(EntityPlayer player, int x, int y, int z) {
        super(player);
        ItemStack townBuilder = EntityTools.getItemFromEitherHand(player, ItemTownBuilder.class);
        if (townBuilder.func_190926_b()) {
            return;
        }
        this.townName = ItemTownBuilder.getTownName(townBuilder);
        this.width = ItemTownBuilder.getWidth(townBuilder);
        this.length = ItemTownBuilder.getLength(townBuilder);
    }

    public void handleNameSelection(String name) {
        this.sendDataToServer("townName", (NBTBase)new NBTTagString(name));
    }

    public void handleWidthUpdate(int width) {
        this.sendDataToServer("width", (NBTBase)new NBTTagInt(width));
    }

    public void handleLengthUpdate(int length) {
        this.sendDataToServer("length", (NBTBase)new NBTTagInt(length));
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack townBuilder = EntityTools.getItemFromEitherHand(this.player, ItemTownBuilder.class);
        if (tag.func_74764_b("townName")) {
            ItemTownBuilder.setTownName(townBuilder, tag.func_74779_i("townName"));
        }
        if (tag.func_74764_b("width")) {
            ItemTownBuilder.setWidth(townBuilder, tag.func_74762_e("width"));
        }
        if (tag.func_74764_b("length")) {
            ItemTownBuilder.setLength(townBuilder, tag.func_74762_e("length"));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }
}

