/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.datafixes;

import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class TileLootFixer
extends RuleDataFixerBase
implements IFixableData {
    private static final String TE_DATA_TAG = "teData";
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 9);

    public int func_188216_a() {
        return 8;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String id = compound.func_74779_i("id");
        if (id.equals("ancientwarfarestructure:loot_basket") || id.equals("ancientwarfarestructure:advanced_loot_chest_tile")) {
            String lootTableName = compound.func_74779_i("LootTable");
            int lootRolls = compound.func_74762_e("lootRolls");
            LootSettings lootSettings = new LootSettings();
            lootSettings.setHasLoot(true);
            lootSettings.setLootRolls(lootRolls);
            lootSettings.setLootTableName(new ResourceLocation(lootTableName));
            compound.func_74782_a("lootSettings", (NBTBase)lootSettings.serializeNBT());
        }
        return compound;
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return ruleName.equals("blockTile");
    }

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        NBTTagCompound tag;
        try {
            tag = JsonToNBT.func_180713_a((String)data.substring("JSON:".length()));
        }
        catch (NBTException e) {
            AncientWarfareStructure.LOG.error("Error getting nbt from json string: ", (Throwable)e);
            return new FixResult.NotModified<String>(data);
        }
        if (tag.func_74764_b(TE_DATA_TAG)) {
            tag.func_74782_a(TE_DATA_TAG, (NBTBase)this.func_188217_a(tag.func_74775_l(TE_DATA_TAG)));
            return new FixResult.Modified<String>("JSON:" + tag.toString(), "TileLootFixer");
        }
        return new FixResult.NotModified<String>(data);
    }
}

