/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.entity;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public class EntitySeat
extends Entity
implements IEntityAdditionalSpawnData {
    private BlockPos seatPos = BlockPos.field_177992_a;

    public EntitySeat(World world) {
        super(world);
        this.func_70105_a(0.01f, 0.01f);
    }

    public EntitySeat(World world, Vec3d position, BlockPos seatPos) {
        super(world);
        this.seatPos = seatPos;
        this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        this.func_70105_a(0.01f, 0.01f);
    }

    protected void func_70088_a() {
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        this.getRotationLimit().ifPresent(rotationLimit -> {
            if (!rotationLimit.isWithinLimit(passenger.field_70177_z)) {
                passenger.field_70177_z = rotationLimit.getMidPoint();
                passenger.field_70126_B = rotationLimit.getMidPoint();
            }
        });
    }

    public void func_70030_z() {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.field_70170_p.func_175623_d(this.seatPos))) {
            this.func_70106_y();
            this.field_70170_p.func_175666_e(this.func_180425_c(), this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c());
            return;
        }
        if (!this.field_70170_p.field_72995_K || !this.func_184207_aI()) {
            return;
        }
        this.restrictPlayerRotation();
    }

    private void restrictPlayerRotation() {
        this.getRotationLimit().ifPresent(rotationLimit -> {
            if (!(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer passenger = (EntityPlayer)this.func_184188_bt().get(0);
            if (!rotationLimit.isWithinLimit(passenger.field_70177_z)) {
                float rotation;
                passenger.field_70126_B = rotation = rotationLimit.restrictToLimit(passenger.field_70177_z);
                passenger.field_70177_z = rotation;
            }
        });
    }

    private Optional<RotationLimit> getRotationLimit() {
        IBlockState state = this.field_70170_p.func_180495_p(this.seatPos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockSeat)) {
            return Optional.empty();
        }
        BlockSeat seat = (BlockSeat)block;
        RotationLimit rotationLimit = seat.getRotationLimit(this.field_70170_p, this.seatPos, state);
        return Optional.of(rotationLimit);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.seatPos = BlockPos.func_177969_a((long)compound.func_74763_f("seatPos"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74772_a("seatPos", this.seatPos.func_177986_g());
    }

    public BlockPos getSeatPos() {
        return this.seatPos;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.seatPos.func_177986_g());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.seatPos = BlockPos.func_177969_a((long)additionalData.readLong());
    }
}

