/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gamedata;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;

public class StructureEntry {
    public String name;
    private int value;
    public final StructureBB bb;
    private BlockPos protectionFlagPos = BlockPos.field_177992_a;
    private int cx;
    private int cz;

    public void setProtectionFlagPos(BlockPos protectionFlagPos) {
        this.protectionFlagPos = protectionFlagPos;
    }

    public StructureEntry(int x, int y, int z, EnumFacing face, StructureTemplate template) {
        this.name = template.name;
        this.bb = new StructureBB(new BlockPos(x, y, z), face, template.getSize(), template.getOffset());
        this.cx = x >> 4;
        this.cz = z >> 4;
        this.value = template.getValidationSettings().getClusterValue();
    }

    public StructureEntry(StructureBB bb, String name, int value, int cx, int cz) {
        this.name = name;
        this.bb = bb;
        this.value = value;
        this.cx = cx;
        this.cz = cz;
    }

    public StructureEntry() {
        this.bb = new StructureBB(BlockPos.field_177992_a, BlockPos.field_177992_a);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("value", this.value);
        tag.func_74783_a("bb", new int[]{this.bb.min.func_177958_n(), this.bb.min.func_177956_o(), this.bb.min.func_177952_p(), this.bb.max.func_177958_n(), this.bb.max.func_177956_o(), this.bb.max.func_177952_p()});
        tag.func_74772_a("protectionFlagPos", this.protectionFlagPos.func_177986_g());
        tag.func_74768_a("cx", 4);
        tag.func_74768_a("cz", 4);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.value = tag.func_74762_e("value");
        int[] datas = tag.func_74759_k("bb");
        if (datas.length >= 6) {
            this.bb.min = new BlockPos(datas[0], datas[1], datas[2]);
            this.bb.max = new BlockPos(datas[3], datas[4], datas[5]);
        }
        this.protectionFlagPos = BlockPos.func_177969_a((long)tag.func_74763_f("protectionFlagPos"));
        this.cx = tag.func_74762_e("cx");
        this.cz = tag.func_74762_e("cz");
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public StructureBB getBB() {
        return this.bb;
    }

    public BlockPos getProtectionFlagPos() {
        return this.protectionFlagPos;
    }

    public int getChunkZ() {
        return this.cz;
    }

    public int getChunkX() {
        return this.cx;
    }
}

