/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.GuiIngameForge;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiSelectFromList;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.structure.container.ContainerStatue;
import net.shadowmage.ancientwarfare.structure.render.statue.StatueEntityRegistry;
import net.shadowmage.ancientwarfare.structure.tile.EntityStatueInfo;

public class GuiStatue
extends GuiContainerBase<ContainerStatue> {
    private String selectedPart = "";
    private boolean hideGUI;

    public GuiStatue(ContainerBase container) {
        super(container, GuiStatue.getScaledResolution().func_78326_a(), GuiStatue.getScaledResolution().func_78328_b());
        this.hideGUI = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        GuiIngameForge.renderCrosshairs = false;
        GuiIngameForge.renderHotbar = false;
    }

    private static ScaledResolution getScaledResolution() {
        return new ScaledResolution(Minecraft.func_71410_x());
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
    }

    @Override
    public void initElements() {
    }

    @Override
    protected boolean onGuiCloseRequested() {
        GuiIngameForge.renderCrosshairs = true;
        GuiIngameForge.renderHotbar = true;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = this.hideGUI;
        return super.onGuiCloseRequested();
    }

    private void updateOverallTransform(Consumer<EntityStatueInfo.Transform> update) {
        EntityStatueInfo.Transform transform = ((ContainerStatue)((Object)this.getContainer())).getStatueInfo().getOverallTransform();
        update.accept(transform);
        ((ContainerStatue)((Object)this.getContainer())).updateServer();
    }

    private void updatePartTransform(Consumer<EntityStatueInfo.Transform> update) {
        EntityStatueInfo.Transform transform = this.getSelectedPartTransform();
        update.accept(transform);
        ((ContainerStatue)((Object)this.getContainer())).getStatueInfo().setPartTransform(this.selectedPart, transform);
        ((ContainerStatue)((Object)this.getContainer())).updateServer();
    }

    private EntityStatueInfo.Transform getSelectedPartTransform() {
        return ((ContainerStatue)((Object)this.getContainer())).getStatueInfo().getPartTransforms().getOrDefault(this.selectedPart, new EntityStatueInfo.Transform());
    }

    private Float getPartTransformValue(Function<EntityStatueInfo.Transform, Float> getValue) {
        return getValue.apply(this.getSelectedPartTransform());
    }

    private Set<String> getModelPartNames(EntityStatueInfo statueInfo) {
        return StatueEntityRegistry.getStatueEntity(statueInfo.getStatueEntityName()).getStatueModel().getModelPartNames();
    }

    private void addRotationInput(int topY, int leftOffset, Supplier<Float> getCurrentValue, final Consumer<Float> updateValue) {
        NumberInput rotation = new NumberInput(leftOffset, topY, 30, getCurrentValue.get().floatValue(), this){

            @Override
            public void onValueUpdated(float value) {
                updateValue.accept(Float.valueOf(value));
            }
        };
        rotation.setIntegerValue();
        rotation.setIncrementAmount(5.0f);
        rotation.setAllowNegative();
        this.addGuiElement(rotation);
    }

    private void addXYZLabels(int topY, int leftOffset) {
        this.addGuiElement(new Label(leftOffset + 13, topY, "X"));
        this.addGuiElement(new Label(leftOffset + 47, topY, "Y"));
        this.addGuiElement(new Label(leftOffset + 87, topY, "Z"));
    }

    private void addOffsetInput(int topY, int leftOffset, Supplier<Float> getCurrentValue, final Consumer<Float> updateValue) {
        NumberInput offset = new NumberInput(leftOffset, topY, 30, getCurrentValue.get().floatValue(), this){

            @Override
            public void onValueUpdated(float value) {
                updateValue.accept(Float.valueOf(value));
            }
        };
        offset.setIncrementAmount(0.0625f);
        offset.setDecimalPlaces(1);
        offset.setAllowNegative();
        this.addGuiElement(offset);
    }

    @Override
    public void setupElements() {
        Iterator<String> it;
        this.clearElements();
        int topY = 4;
        int leftOffset = 4;
        final EntityStatueInfo statueInfo = ((ContainerStatue)((Object)this.getContainer())).getStatueInfo();
        this.addGuiElement(new Button(leftOffset, topY, 100, 14, statueInfo.getStatueEntityName()){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiStatue.this, this.text, s -> s, () -> StatueEntityRegistry.getStatueEntityNames().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList()), s -> {
                    statueInfo.setStatueEntityName((String)s);
                    ((ContainerStatue)((Object)((Object)GuiStatue.this.getContainer()))).updateServer();
                    GuiStatue.this.refreshGui();
                }));
            }
        });
        this.addGuiElement(new Label(leftOffset, topY += 18, "Offset"));
        this.addXYZLabels(topY += 12, leftOffset);
        this.addOffsetInput(topY += 12, leftOffset, () -> Float.valueOf(statueInfo.getOverallTransform().getOffsetX()), val -> this.updateOverallTransform(t -> t.setOffsetX(val.floatValue())));
        this.addOffsetInput(topY, leftOffset + 35, () -> Float.valueOf(statueInfo.getOverallTransform().getOffsetY()), val -> this.updateOverallTransform(t -> t.setOffsetY(val.floatValue())));
        this.addOffsetInput(topY, leftOffset + 70, () -> Float.valueOf(statueInfo.getOverallTransform().getOffsetZ()), val -> this.updateOverallTransform(t -> t.setOffsetZ(val.floatValue())));
        this.addGuiElement(new Label(leftOffset, topY += 16, "Rotation"));
        this.addXYZLabels(topY += 12, leftOffset);
        this.addRotationInput(topY += 12, leftOffset, () -> Float.valueOf(statueInfo.getOverallTransform().getRotationX()), val -> this.updateOverallTransform(t -> t.setRotationX(val.floatValue())));
        this.addRotationInput(topY, leftOffset + 35, () -> Float.valueOf(statueInfo.getOverallTransform().getRotationY()), val -> this.updateOverallTransform(t -> t.setRotationY(val.floatValue())));
        this.addRotationInput(topY, leftOffset + 70, () -> Float.valueOf(statueInfo.getOverallTransform().getRotationZ()), val -> this.updateOverallTransform(t -> t.setRotationZ(val.floatValue())));
        topY += 16;
        this.addGuiElement(new Label(leftOffset, topY += 2, "Scale"));
        NumberInput scaleInput = new NumberInput(leftOffset + 70, topY, 30, statueInfo.getOverallTransform().getScale(), this){

            @Override
            public void onValueUpdated(float value) {
                GuiStatue.this.updateOverallTransform(t -> t.setScale(value));
            }
        };
        scaleInput.setDecimalPlaces(1);
        scaleInput.setIncrementAmount(0.1f);
        this.addGuiElement(scaleInput);
        topY += 16;
        topY += 4;
        if (this.selectedPart.isEmpty() && (it = this.getModelPartNames(statueInfo).iterator()).hasNext()) {
            this.selectedPart = it.next();
        }
        this.addGuiElement(new Button(leftOffset, topY, 80, 14, this.selectedPart.isEmpty() ? "Select Model Part" : this.selectedPart){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiStatue.this, this.text, s -> s, () -> GuiStatue.this.getModelPartNames(statueInfo).stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList()), s -> {
                    GuiStatue.this.selectedPart = s;
                    GuiStatue.this.refreshGui();
                }, false));
            }
        });
        topY += 18;
        if (this.selectedPart.isEmpty()) {
            return;
        }
        this.addGuiElement(new Label(leftOffset, topY, "Offset"));
        this.addXYZLabels(topY += 12, leftOffset);
        this.addOffsetInput(topY += 12, leftOffset, () -> this.getPartTransformValue(EntityStatueInfo.Transform::getOffsetX), val -> this.updatePartTransform(t -> t.setOffsetX(val.floatValue())));
        this.addOffsetInput(topY, leftOffset + 35, () -> this.getPartTransformValue(EntityStatueInfo.Transform::getOffsetY), val -> this.updatePartTransform(t -> t.setOffsetY(val.floatValue())));
        this.addOffsetInput(topY, leftOffset + 70, () -> this.getPartTransformValue(EntityStatueInfo.Transform::getOffsetZ), val -> this.updatePartTransform(t -> t.setOffsetZ(val.floatValue())));
        this.addGuiElement(new Label(leftOffset, topY += 16, "Rotation"));
        this.addXYZLabels(topY += 12, leftOffset);
        this.addRotationInput(topY += 12, leftOffset, () -> this.getPartTransformValue(t -> Float.valueOf(Trig.toDegrees(t.getRotationX()))), val -> this.updatePartTransform(t -> t.setRotationX(Trig.toRadians(val.floatValue()))));
        this.addRotationInput(topY, leftOffset + 35, () -> this.getPartTransformValue(t -> Float.valueOf(Trig.toDegrees(t.getRotationY()))), val -> this.updatePartTransform(t -> t.setRotationY(Trig.toRadians(val.floatValue()))));
        this.addRotationInput(topY, leftOffset + 70, () -> this.getPartTransformValue(t -> Float.valueOf(Trig.toDegrees(t.getRotationZ()))), val -> this.updatePartTransform(t -> t.setRotationZ(Trig.toRadians(val.floatValue()))));
        this.addGuiElement(new Label(leftOffset + 120, this.field_146295_m - 32, "Press ESC to exit this screen"));
        this.addGuiElement(new Label(leftOffset + 120, this.field_146295_m - 16, "HINT: Use mouse wheel over values to change them quickly"));
    }

    public void func_146276_q_() {
    }
}

