/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.gui.GuiLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class ItemLootChestPlacer
extends ItemBaseStructure
implements IItemKeyInterface {
    private static final String LOOT_SETTINGS_TAG = "lootSettings";
    private static final List<ItemStack> LOOT_CONTAINERS = new ArrayList<ItemStack>();
    public static final String BLOCK_STACK_TAG = "blockStack";

    public static List<ItemStack> getLootContainers() {
        return LOOT_CONTAINERS;
    }

    public static void registerLootContainer(ItemStack lootContainer) {
        LOOT_CONTAINERS.add(lootContainer);
    }

    public ItemLootChestPlacer() {
        super("loot_chest_placer");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 55, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String keyText = InputHandler.ALT_ITEM_USE_1.getDisplayName();
        String text = keyText + " = " + I18n.func_135052_a((String)"guistrings.structure.loot_placer.copy", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_2.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.structure.loot_placer.paste", (Object[])new Object[0]);
        tooltip.add(text);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack placer = player.func_184586_b(hand);
        Optional<LootSettings> lootSettings = ItemLootChestPlacer.getLootSettings(placer);
        if (!lootSettings.isPresent()) {
            return EnumActionResult.PASS;
        }
        BlockPos placePos = pos.func_177972_a(facing);
        ItemStack itemBlockStack = ItemLootChestPlacer.getBlockStack(placer);
        ItemBlock itemBlock = (ItemBlock)itemBlockStack.func_77973_b();
        Block block = itemBlock.func_179223_d();
        if (block.func_176196_c(world, placePos)) {
            itemBlock.placeBlockAt(itemBlockStack, player, world, placePos, facing, hitX, hitY, hitZ, block.getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, itemBlockStack.func_77960_j(), (EntityLivingBase)player, hand));
            WorldTools.getTile((IBlockAccess)world, placePos, ISpecialLootContainer.class).ifPresent(t -> ((LootSettings)lootSettings.get()).transferToContainer((ISpecialLootContainer)t));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static ItemStack getBlockStack(ItemStack placer) {
        return placer.func_77942_o() && placer.func_77978_p().func_74764_b(BLOCK_STACK_TAG) ? new ItemStack(placer.func_77978_p().func_74775_l(BLOCK_STACK_TAG)) : LOOT_CONTAINERS.get(0);
    }

    public static void setBlockStack(ItemStack placer, ItemStack blockStack) {
        placer.func_77983_a(BLOCK_STACK_TAG, (NBTBase)blockStack.func_77955_b(new NBTTagCompound()));
    }

    public static Optional<LootSettings> getLootSettings(ItemStack placer) {
        return placer.func_77942_o() && placer.func_77978_p().func_74764_b(LOOT_SETTINGS_TAG) ? Optional.of(LootSettings.deserializeNBT(placer.func_77978_p().func_74775_l(LOOT_SETTINGS_TAG))) : Optional.empty();
    }

    public static void setLootSettings(ItemStack placer, LootSettings lootSettings) {
        placer.func_77983_a(LOOT_SETTINGS_TAG, (NBTBase)lootSettings.serializeNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(55, GuiLootChestPlacer.class);
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1 || altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack placer, IItemKeyInterface.ItemAltFunction altFunction) {
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, false);
        WorldTools.getTile((IBlockAccess)player.field_70170_p, hit, ISpecialLootContainer.class).ifPresent(te -> {
            if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1) {
                IBlockState state = player.field_70170_p.func_180495_p(hit);
                ItemLootChestPlacer.setBlockStack(placer, state.func_177230_c().getPickBlock(state, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.UP, hit), player.field_70170_p, hit, player));
                ItemLootChestPlacer.getLootSettings(placer).ifPresent(s -> ItemLootChestPlacer.setLootSettings(placer, s.transferFromContainer((ISpecialLootContainer)te)));
            } else if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2) {
                ItemLootChestPlacer.getLootSettings(placer).ifPresent(s -> s.transferToContainer((ISpecialLootContainer)te));
                BlockTools.notifyBlockUpdate(player.field_70170_p, hit);
            }
        });
    }
}

