/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.registry.EntitySpawnNBTRegistry;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ItemSpawnerPlacer
extends ItemBaseStructure
implements IItemKeyInterface {
    private static final String SPAWNER_DATA_TAG = "spawnerData";

    public ItemSpawnerPlacer(String name) {
        super(name);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"guistrings.selected_mob", (Object[])new Object[0]) + ":");
        if (stack.func_77942_o() && ItemSpawnerPlacer.hasSpawnerData(stack)) {
            SpawnerSettings settings = new SpawnerSettings();
            settings.readFromNBT(ItemSpawnerPlacer.getSpawnerData(stack));
            if (!settings.getSpawnGroups().isEmpty() && !settings.getSpawnGroups().get(0).getEntitiesToSpawn().isEmpty()) {
                tooltip.add(I18n.func_135052_a((String)settings.getSpawnGroups().get(0).getEntitiesToSpawn().get(0).getEntityName(), (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"guistrings.no_selection", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_70170_p.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (stack.func_190926_b()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Optional<BlockPos> placementPosition = this.getPlacementPosition(world, player);
        if (placementPosition.isPresent()) {
            if (ItemSpawnerPlacer.hasSpawnerData(stack)) {
                this.placeSpawner(player, stack, placementPosition.get());
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.spawner.nodata", new Object[0]));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.spawner.noblock", new Object[0]));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void placeSpawner(EntityPlayer player, ItemStack stack, BlockPos placePos) {
        if (player.field_70170_p.func_175656_a(placePos, AWStructureBlocks.ADVANCED_SPAWNER.func_176223_P())) {
            WorldTools.getTile((IBlockAccess)player.field_70170_p, placePos, TileAdvancedSpawner.class).ifPresent(t -> {
                SpawnerSettings settings = new SpawnerSettings();
                settings.readFromNBT(ItemSpawnerPlacer.getSpawnerData(stack));
                t.setSettings(settings);
            });
        }
    }

    public static NBTTagCompound getSpawnerData(ItemStack stack) {
        return stack.func_77978_p().func_74775_l(SPAWNER_DATA_TAG);
    }

    public static boolean hasSpawnerData(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(SPAWNER_DATA_TAG);
    }

    private Optional<BlockPos> getPlacementPosition(World world, EntityPlayer player) {
        EnumFacing offset;
        RayTraceResult traceResult = this.func_77621_a(player.field_70170_p, player, !player.func_70093_af());
        if (traceResult == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return Optional.empty();
        }
        BlockPos placementPos = traceResult.func_178782_a().func_177972_a(traceResult.field_178784_b);
        if (!world.func_180495_p(placementPos).func_177230_c().func_176200_f((IBlockAccess)world, placementPos) && !world.func_180495_p(placementPos = placementPos.func_177972_a(offset = traceResult.field_178784_b.func_176740_k().func_176722_c() ? (player.field_70125_A < 0.0f ? EnumFacing.DOWN : EnumFacing.UP) : player.func_174811_aO().func_176734_d())).func_177230_c().func_176200_f((IBlockAccess)world, placementPos)) {
            return Optional.empty();
        }
        return Optional.of(placementPos);
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack spawnerPlacer = EntityTools.getItemFromEitherHand(player, ItemSpawnerPlacer.class);
        if (!spawnerPlacer.func_190926_b()) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            Entity entity = event.getTarget();
            SpawnerSettings settings = new SpawnerSettings();
            SpawnerSettings.EntitySpawnGroup group = new SpawnerSettings.EntitySpawnGroup(settings);
            SpawnerSettings.EntitySpawnSettings spawnSettings = new SpawnerSettings.EntitySpawnSettings(group);
            if (ItemSpawnerPlacer.hasSpawnerData(spawnerPlacer)) {
                settings.readFromNBT(ItemSpawnerPlacer.getSpawnerData(spawnerPlacer));
                spawnSettings = this.getFirstEntitySpawnSettings(settings);
            } else {
                this.setDefaultEntitySpawnSettings(spawnSettings);
                group.addSpawnSetting(spawnSettings);
                settings.addSpawnGroup(group);
                settings.setSpawnDelay(0);
                settings.setMinDelay(10);
                settings.setMaxDelay(10);
                settings.setSpawnRange(0);
                settings.setPlayerRange(16);
                settings.toggleTransparent();
            }
            spawnSettings.setEntityToSpawn(entity);
            spawnSettings.setCustomSpawnTag(this.getCustomSpawnTag(entity));
            ItemSpawnerPlacer.setSpawnerData(spawnerPlacer, settings);
            entity.func_70106_y();
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.spawner.entity_set", new Object[]{entity.func_70005_c_()}));
        }
    }

    private void setDefaultEntitySpawnSettings(SpawnerSettings.EntitySpawnSettings spawnSettings) {
        spawnSettings.setSpawnLimitTotal(1);
        spawnSettings.setSpawnCountMin(1);
        spawnSettings.setSpawnCountMax(1);
    }

    private SpawnerSettings.EntitySpawnSettings getFirstEntitySpawnSettings(SpawnerSettings settings) {
        SpawnerSettings.EntitySpawnSettings spawnSettings;
        SpawnerSettings.EntitySpawnGroup group;
        if (settings.getSpawnGroups().isEmpty()) {
            group = new SpawnerSettings.EntitySpawnGroup(settings);
            settings.addSpawnGroup(group);
        } else {
            group = settings.getSpawnGroups().iterator().next();
        }
        if (group.getEntitiesToSpawn().isEmpty()) {
            spawnSettings = new SpawnerSettings.EntitySpawnSettings(group);
            this.setDefaultEntitySpawnSettings(spawnSettings);
            group.addSpawnSetting(spawnSettings);
        } else {
            spawnSettings = group.getEntitiesToSpawn().iterator().next();
        }
        return spawnSettings;
    }

    private static void setSpawnerData(ItemStack spawnerPlacer, SpawnerSettings settings) {
        ItemSpawnerPlacer.setSpawnerData(spawnerPlacer, settings.writeToNBT(new NBTTagCompound()));
    }

    public static void setSpawnerData(ItemStack spawnerPlacer, NBTTagCompound settingsNbt) {
        spawnerPlacer.func_77983_a(SPAWNER_DATA_TAG, (NBTBase)settingsNbt);
    }

    private NBTTagCompound getCustomSpawnTag(Entity entity) {
        NBTTagCompound entityTag = new NBTTagCompound();
        entity.func_189511_e(entityTag);
        return EntitySpawnNBTRegistry.getEntitySpawnNBT(entity, entityTag);
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (!ItemSpawnerPlacer.hasSpawnerData(stack)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have an entity set first!"));
            return;
        }
        if (player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 9, 0, 0, 0);
        } else {
            NetworkHandler.INSTANCE.openGui(player, 7, 0, 0, 0);
        }
    }
}

