/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureSelection;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.render.PreviewRenderer;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;

public class ItemStructureBuilder
extends ItemBaseStructure
implements IItemKeyInterface,
IBoxRenderer {
    private static final String LOCK_POS_TAG = "lockPos";

    public ItemStructureBuilder(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String structure = "guistrings.structure.no_selection";
        ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(stack);
        if (viewSettings.hasName()) {
            structure = viewSettings.name;
        }
        tooltip.add(I18n.func_135052_a((String)"guistrings.current_structure", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)structure, (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStructureSettings buildSettings = ItemStructureSettings.getSettingsFor(stack);
        if (buildSettings.hasName()) {
            Optional<StructureTemplate> template = StructureTemplateManager.getTemplate(buildSettings.name);
            if (!template.isPresent()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.template.not_found", new Object[0]));
                return;
            }
            Optional<Tuple<BlockPos, EnumFacing>> buildPos = this.getBuildPosFromStackOrPlayer(player, stack);
            if (!buildPos.isPresent()) {
                return;
            }
            BlockPos hit = (BlockPos)buildPos.get().func_76341_a();
            EnumFacing facing = (EnumFacing)buildPos.get().func_76340_b();
            StructureBuilder builder = new StructureBuilder(player.field_70170_p, template.get(), facing, hit);
            builder.getTemplate().getValidationSettings().preGeneration(player.field_70170_p, hit, facing, builder.getTemplate(), builder.getBoundingBox());
            builder.instantConstruction();
            builder.getTemplate().getValidationSettings().postGeneration(player.field_70170_p, hit, builder.getBoundingBox(), builder.getTemplate());
            this.removeLockPosition(stack);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.no_selection", new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
            NetworkHandler.INSTANCE.openGui(player, 2, 0, 0, 0);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && this.getLockPosition(stack).isPresent()) {
            this.removeLockPosition(stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void removeLockPosition(ItemStack stack) {
        stack.func_77978_p().func_82580_o(LOCK_POS_TAG);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStructureSettings buildSettings = ItemStructureSettings.getSettingsFor(stack);
        if (player.func_70093_af() && buildSettings.hasName()) {
            if (!worldIn.field_72995_K) {
                this.lockPosition(stack, pos.func_177972_a(facing), player);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    private void lockPosition(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74772_a(LOCK_POS_TAG, pos.func_177986_g());
        tag.func_74774_a("lockFacing", (byte)player.func_174811_aO().func_176736_b());
    }

    private Optional<Tuple<BlockPos, EnumFacing>> getLockPosition(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b(LOCK_POS_TAG) ? Optional.of(new Tuple((Object)BlockPos.func_177969_a((long)tag.func_74763_f(LOCK_POS_TAG)), (Object)EnumFacing.field_176754_o[tag.func_74771_c("lockFacing")])) : Optional.empty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBox(EntityPlayer player, EnumHand hand, ItemStack stack, float delta) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
        if (!settings.hasName()) {
            return;
        }
        String name = settings.name();
        Optional<StructureTemplate> template = StructureTemplateManager.getTemplate(name);
        if (!template.isPresent()) {
            return;
        }
        Optional<Tuple<BlockPos, EnumFacing>> buildPos = this.getBuildPosFromStackOrPlayer(player, stack);
        if (!buildPos.isPresent()) {
            return;
        }
        BlockPos hit = (BlockPos)buildPos.get().func_76341_a();
        EnumFacing facing = (EnumFacing)buildPos.get().func_76340_b();
        StructureBB bb = new StructureBB(hit, facing, template.get().getSize(), template.get().getOffset());
        int turns = (facing.func_176736_b() + 2) % 4;
        IBoxRenderer.Util.renderBoundingBox(player, bb.min, bb.max, delta);
        IBoxRenderer.Util.renderBoundingBox(player, hit, hit, delta);
        PreviewRenderer.renderTemplatePreview(player, hand, stack, delta, template.get(), bb, turns);
    }

    private Optional<Tuple<BlockPos, EnumFacing>> getBuildPosFromStackOrPlayer(EntityPlayer player, ItemStack stack) {
        Optional<Tuple<BlockPos, EnumFacing>> buildPos;
        Optional<Tuple<BlockPos, EnumFacing>> lockPosition = this.getLockPosition(stack);
        if (lockPosition.isPresent()) {
            buildPos = lockPosition;
        } else {
            BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (hit == null) {
                return Optional.empty();
            }
            buildPos = Optional.of(new Tuple((Object)hit, (Object)player.func_174811_aO()));
        }
        return buildPos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(2, GuiStructureSelection.class);
    }
}

