/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.util.PacketHelper;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;

public class PacketStructureEntry
extends PacketBase {
    private int dimension;
    private int cx;
    private int cz;
    private StructureEntry entry;
    private boolean unique;

    public PacketStructureEntry() {
    }

    public PacketStructureEntry(int dimension, int cx, int cz, StructureEntry entry, boolean unique) {
        this.dimension = dimension;
        this.cx = cx;
        this.cz = cz;
        this.unique = unique;
        this.entry = entry;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.dimension);
        data.writeInt(this.cx);
        data.writeInt(this.cz);
        data.writeBoolean(this.unique);
        NBTTagCompound entryTag = new NBTTagCompound();
        this.entry.writeToNBT(entryTag);
        PacketHelper.writeNBTTag(data, entryTag);
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        this.dimension = data.readInt();
        this.cx = data.readInt();
        this.cz = data.readInt();
        this.unique = data.readBoolean();
        this.entry = new StructureEntry();
        this.entry.readFromNBT(PacketHelper.readNBTTag(data));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void execute() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            AWGameData.INSTANCE.getData((World)world, StructureMap.class).setGeneratedAt(this.dimension, this.cx, this.cz, this.entry, this.unique);
        }
    }
}

