/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import java.util.HashMap;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.shadowmage.ancientwarfare.structure.entity.DualBoundingBox;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateBasic;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateDouble;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateRotatingBridge;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateSingle;

public final class RenderGateHelper
extends Render<EntityGate> {
    private HashMap<Integer, Render> gateRenders = new HashMap();

    public RenderGateHelper(RenderManager renderManager) {
        super(renderManager);
        this.addGateRender(0, new RenderGateBasic(renderManager));
        this.addGateRender(1, new RenderGateBasic(renderManager));
        this.addGateRender(4, new RenderGateSingle(renderManager));
        this.addGateRender(5, new RenderGateSingle(renderManager));
        this.addGateRender(8, new RenderGateDouble(renderManager));
        this.addGateRender(9, new RenderGateDouble(renderManager));
        this.addGateRender(12, new RenderGateRotatingBridge(renderManager));
    }

    protected void addGateRender(int type, Render rend) {
        this.gateRenders.put(type, rend);
    }

    public void doRender(EntityGate gate, double d0, double d1, double d2, float f, float f1) {
        GlStateManager.func_179094_E();
        if (this.field_76990_c.func_178634_b() && !gate.func_82150_aj()) {
            double x = d0 - gate.field_70142_S;
            double y = d1 - gate.field_70137_T;
            double z = d2 - gate.field_70136_U;
            if (gate.edgePosition > 0.0f && gate.func_174813_aQ() instanceof DualBoundingBox) {
                RenderGateHelper.func_76978_a((AxisAlignedBB)((DualBoundingBox)gate.func_174813_aQ()).getTop(), (double)x, (double)y, (double)z);
                RenderGateHelper.func_76978_a((AxisAlignedBB)((DualBoundingBox)gate.func_174813_aQ()).getMin(), (double)x, (double)y, (double)z);
                RenderGateHelper.func_76978_a((AxisAlignedBB)((DualBoundingBox)gate.func_174813_aQ()).getMax(), (double)x, (double)y, (double)z);
            } else {
                RenderGateHelper.func_76978_a((AxisAlignedBB)gate.func_174813_aQ(), (double)x, (double)y, (double)z);
            }
            GlStateManager.func_179121_F();
            return;
        }
        if (gate.hurtAnimationTicks > 0) {
            float percent = (float)gate.hurtAnimationTicks / 20.0f;
            GlStateManager.func_179131_c((float)1.0f, (float)(1.0f - percent), (float)(1.0f - percent), (float)1.0f);
        }
        this.func_180548_c(gate);
        GlStateManager.func_179137_b((double)d0, (double)d1, (double)d2);
        GlStateManager.func_179114_b((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.gateRenders.get(gate.getGateType().getGlobalID()).func_76986_a((Entity)gate, d0, d1, d2, f, f1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityGate entity) {
        return entity.getGateType().getTexture();
    }
}

