/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.statue;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelGuardian;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.shadowmage.ancientwarfare.structure.render.statue.StatueModelBase;
import net.shadowmage.ancientwarfare.structure.tile.EntityStatueInfo;

public class GuardianStatueModel
extends StatueModelBase<ModelGuardian> {
    private Map<String, EntityStatueInfo.Transform> baseTransforms = new HashMap<String, EntityStatueInfo.Transform>();
    private static final Field BODY_FIELD = ObfuscationReflectionHelper.findField(ModelGuardian.class, (String)"field_178710_a");
    private static final Field EYE_FIELD = ObfuscationReflectionHelper.findField(ModelGuardian.class, (String)"field_178708_b");
    private static final Field SPINES_FIELD = ObfuscationReflectionHelper.findField(ModelGuardian.class, (String)"field_178709_c");
    private static final Field TAIL_FIELD = ObfuscationReflectionHelper.findField(ModelGuardian.class, (String)"field_178707_d");

    public GuardianStatueModel() {
        super(new ModelGuardian());
        this.initRenderers();
    }

    private void initRenderers() {
        float[] afloat = new float[]{1.75f, 0.25f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 1.25f, 0.75f, 0.0f, 0.0f};
        float[] afloat1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 1.75f, 1.25f, 0.75f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] afloat2 = new float[]{0.0f, 0.0f, 0.25f, 1.75f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.75f, 1.25f};
        float[] afloat3 = new float[]{0.0f, 0.0f, 8.0f, -8.0f, -8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f, 8.0f, -8.0f};
        float[] afloat4 = new float[]{-8.0f, -8.0f, -8.0f, -8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f};
        float[] afloat5 = new float[]{8.0f, -8.0f, 0.0f, 0.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f};
        for (int i = 0; i < 12; ++i) {
            EntityStatueInfo.Transform transform = new EntityStatueInfo.Transform();
            transform.setRotationX((float)Math.PI * afloat[i]);
            transform.setRotationY((float)Math.PI * afloat1[i]);
            transform.setRotationZ((float)Math.PI * afloat2[i]);
            this.baseTransforms.put("Spine " + (i + 1), transform);
            this.getSpines()[i].field_78800_c = afloat3[i] * (1.0f + MathHelper.func_76134_b((float)i) * 0.01f - 0.55f);
            this.getSpines()[i].field_78797_d = 16.0f + afloat4[i] * (1.0f + MathHelper.func_76134_b((float)i) * 0.01f - 0.55f);
            this.getSpines()[i].field_78798_e = afloat5[i] * (1.0f + MathHelper.func_76134_b((float)i) * 0.01f - 0.55f);
        }
        this.getEye().field_78798_e = -8.25f;
        this.getTail()[1].field_78800_c = -1.5f;
        this.getTail()[1].field_78797_d = 0.5f;
        this.getTail()[1].field_78798_e = 14.0f;
        this.getTail()[2].field_78800_c = 0.5f;
        this.getTail()[2].field_78797_d = 0.5f;
        this.getTail()[2].field_78798_e = 6.0f;
    }

    @Override
    protected Map<String, ModelRenderer> getNameRendererMap() {
        return new ImmutableMap.Builder().put((Object)"Body", (Object)this.getBody()).put((Object)"Eye", (Object)this.getEye()).put((Object)"Spine 1", (Object)this.getSpines()[0]).put((Object)"Spine 2", (Object)this.getSpines()[1]).put((Object)"Spine 3", (Object)this.getSpines()[2]).put((Object)"Spine 4", (Object)this.getSpines()[3]).put((Object)"Spine 5", (Object)this.getSpines()[4]).put((Object)"Spine 6", (Object)this.getSpines()[5]).put((Object)"Spine 7", (Object)this.getSpines()[6]).put((Object)"Spine 8", (Object)this.getSpines()[7]).put((Object)"Spine 9", (Object)this.getSpines()[8]).put((Object)"Spine 10", (Object)this.getSpines()[9]).put((Object)"Spine 11", (Object)this.getSpines()[10]).put((Object)"Spine 12", (Object)this.getSpines()[11]).put((Object)"Tail 1", (Object)this.getTail()[0]).put((Object)"Tail 2", (Object)this.getTail()[1]).put((Object)"Tail 3", (Object)this.getTail()[2]).build();
    }

    @Override
    public Map<String, EntityStatueInfo.Transform> getBaseTransforms() {
        return this.baseTransforms;
    }

    private ModelRenderer getBody() {
        return GuardianStatueModel.getObfuscatedRenderer(this.model, BODY_FIELD);
    }

    @Override
    public void render(float scale) {
        this.getBody().func_78785_a(scale);
    }

    private ModelRenderer[] getTail() {
        return GuardianStatueModel.getObfuscatedRendererArray(this.model, TAIL_FIELD);
    }

    private ModelRenderer getEye() {
        return GuardianStatueModel.getObfuscatedRenderer(this.model, EYE_FIELD);
    }

    private ModelRenderer[] getSpines() {
        return GuardianStatueModel.getObfuscatedRendererArray(this.model, SPINES_FIELD);
    }
}

