/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;

public class StructureBuilderTicked
extends StructureBuilder {
    private static final String CLEAR_POS_TAG = "clearPos";
    private static final String CLEARED_TAG = "cleared";
    private static final String CURRENT_PRIORITY_TAG = "currentPriority";
    private static final String DESTINATION_TAG = "destination";
    public boolean invalid = false;
    private boolean hasClearedArea;
    private BlockPos clearPos;

    public StructureBuilderTicked(World world, StructureTemplate template, EnumFacing face, BlockPos pos) {
        super(world, template, face, pos);
        this.clearPos = new BlockPos(this.bb.min.func_177958_n(), this.bb.max.func_177956_o(), this.bb.min.func_177952_p());
    }

    public StructureBuilderTicked() {
    }

    public void tick() {
        if (!this.hasClearedArea) {
            while (!this.breakClearTargetBlock()) {
                if (this.incrementClear()) continue;
                this.hasClearedArea = true;
                break;
            }
            if (!this.incrementClear()) {
                this.hasClearedArea = true;
            }
        } else if (!this.isFinished()) {
            while (!this.isFinished() && !this.placeAtCurrentPos()) {
            }
            this.increment();
        }
    }

    private boolean placeAtCurrentPos() {
        Optional<TemplateRule> rule = this.template.getRuleAt(this.curTempPos);
        if (rule.isPresent() && rule.get().placeInSurvival() && rule.get().shouldPlaceOnBuildPass(this.world, this.turns, this.destination, this.currentPriority)) {
            rule.ifPresent(this::placeRule);
            return true;
        }
        this.increment();
        return false;
    }

    private boolean breakClearTargetBlock() {
        return BlockTools.breakBlockAndDrop(this.world, this.clearPos);
    }

    private boolean incrementClear() {
        this.clearPos = this.clearPos.func_177974_f();
        if (this.clearPos.func_177958_n() > this.bb.max.func_177958_n()) {
            this.clearPos = new BlockPos(this.bb.min.func_177958_n(), this.clearPos.func_177956_o(), this.clearPos.func_177952_p());
            this.clearPos = this.clearPos.func_177968_d();
            if (this.clearPos.func_177952_p() > this.bb.max.func_177952_p()) {
                this.clearPos = new BlockPos(this.bb.min.func_177958_n(), this.clearPos.func_177977_b().func_177956_o(), this.bb.min.func_177952_p());
                return this.clearPos.func_177956_o() >= this.bb.min.func_177956_o();
            }
        }
        return true;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void readFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("name");
        Optional<StructureTemplate> template = StructureTemplateManager.getTemplate(name);
        if (template.isPresent()) {
            this.template = template.get();
            this.curTempPos = MathUtils.fromLong(tag.func_74763_f("pos"));
            this.clearPos = BlockPos.func_177969_a((long)tag.func_74763_f(CLEAR_POS_TAG));
            this.hasClearedArea = tag.func_74767_n(CLEARED_TAG);
            this.turns = tag.func_74762_e("turns");
            this.buildFace = EnumFacing.field_82609_l[tag.func_74771_c("buildFace")];
            this.maxPriority = tag.func_74762_e("maxPriority");
            this.currentPriority = tag.func_74762_e(CURRENT_PRIORITY_TAG);
            this.destination = BlockPos.func_177969_a((long)tag.func_74763_f(DESTINATION_TAG));
            this.bb = new StructureBB(BlockPos.func_177969_a((long)tag.func_74763_f("bbMin")), BlockPos.func_177969_a((long)tag.func_74763_f("bbMax")));
            this.buildOrigin = BlockPos.func_177969_a((long)tag.func_74763_f("buildOrigin"));
            this.incrementDestination();
        } else {
            this.invalid = true;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.template.name);
        tag.func_74774_a("face", (byte)this.getBuildFace().ordinal());
        tag.func_74768_a("turns", this.turns);
        tag.func_74768_a("maxPriority", this.maxPriority);
        tag.func_74768_a(CURRENT_PRIORITY_TAG, this.currentPriority);
        tag.func_74772_a("pos", MathUtils.toLong(this.curTempPos));
        tag.func_74772_a(CLEAR_POS_TAG, this.clearPos.func_177986_g());
        tag.func_74757_a(CLEARED_TAG, this.hasClearedArea);
        tag.func_74772_a(DESTINATION_TAG, this.destination.func_177986_g());
        tag.func_74772_a("buildOrigin", this.buildOrigin.func_177986_g());
        tag.func_74772_a("bbMin", this.bb.min.func_177986_g());
        tag.func_74772_a("bbMax", this.bb.max.func_177986_g());
    }

    @Override
    public StructureTemplate getTemplate() {
        return this.template;
    }

    public NBTTagCompound serializeProgressData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(CURRENT_PRIORITY_TAG, this.currentPriority);
        tag.func_74772_a("pos", MathUtils.toLong(this.curTempPos));
        tag.func_74772_a(CLEAR_POS_TAG, this.clearPos.func_177986_g());
        tag.func_74757_a(CLEARED_TAG, this.hasClearedArea);
        tag.func_74772_a(DESTINATION_TAG, this.destination.func_177986_g());
        return tag;
    }

    public void deserializeProgressData(NBTTagCompound tag) {
        this.currentPriority = tag.func_74762_e(CURRENT_PRIORITY_TAG);
        this.curTempPos = MathUtils.fromLong(tag.func_74763_f("pos"));
        this.clearPos = BlockPos.func_177969_a((long)tag.func_74763_f(CLEAR_POS_TAG));
        this.hasClearedArea = tag.func_74767_n(CLEARED_TAG);
        this.destination = BlockPos.func_177969_a((long)tag.func_74763_f(DESTINATION_TAG));
    }

    public float getPercentDoneClearing() {
        float max = this.getTotalBlocks();
        BlockPos relativeClearPos = this.clearPos.func_177982_a(-this.bb.min.func_177958_n(), -this.bb.max.func_177956_o(), -this.bb.min.func_177952_p());
        float current = (float)(-relativeClearPos.func_177956_o()) * (float)(this.bb.getXSize() * this.bb.getZSize());
        current += (float)(relativeClearPos.func_177952_p() * this.bb.getXSize());
        return (current += (float)relativeClearPos.func_177958_n()) / max;
    }

    public boolean hasClearedArea() {
        return this.hasClearedArea;
    }
}

