/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import java.util.HashMap;
import java.util.Map;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrixBuilder;

public class BorderMatrixCache {
    private static final Map<StructureDimensions, BorderMatrix> simpleBorderMatrices = new HashMap<StructureDimensions, BorderMatrix>();

    private BorderMatrixCache() {
    }

    public static BorderMatrix getBorderMatrix(int xSize, int zSize, int borderSize) {
        boolean simpleBorder = true;
        BorderMatrix borderMatrix = null;
        if (simpleBorder) {
            StructureDimensions dims = new StructureDimensions(xSize, zSize, borderSize);
            if (!simpleBorderMatrices.containsKey(dims)) {
                simpleBorderMatrices.put(dims, BorderMatrixCache.constructBorderMatrix(dims));
            }
            borderMatrix = simpleBorderMatrices.get(dims);
        }
        return borderMatrix;
    }

    private static BorderMatrix constructBorderMatrix(StructureDimensions dims) {
        return new BorderMatrixBuilder(dims.xSize, dims.zSize, dims.borderSize).build();
    }

    private static class StructureDimensions {
        private int xSize;
        private int zSize;
        private int borderSize;

        public StructureDimensions(int xSize, int zSize, int borderSize) {
            this.xSize = xSize;
            this.zSize = zSize;
            this.borderSize = borderSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureDimensions that = (StructureDimensions)o;
            return this.xSize == that.xSize && this.zSize == that.zSize && this.borderSize == that.borderSize;
        }

        public int hashCode() {
            int result = this.xSize;
            result = 31 * result + this.zSize;
            result = 31 * result + this.borderSize;
            return result;
        }
    }
}

