/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import jdk.nashorn.internal.ir.annotations.Immutable;

@Immutable
public class HorizontalCoords {
    static final Set<HorizontalCoords> ADJACENT_OFFSETS = ImmutableSet.of((Object)new HorizontalCoords(-1, 0), (Object)new HorizontalCoords(1, 0), (Object)new HorizontalCoords(0, -1), (Object)new HorizontalCoords(0, 1));
    private int x;
    private int z;

    public HorizontalCoords(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public HorizontalCoords add(HorizontalCoords offset) {
        return new HorizontalCoords(this.x + offset.x, this.z + offset.z);
    }

    public HorizontalCoords getOpposite() {
        return new HorizontalCoords(-this.x, -this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalCoords that = (HorizontalCoords)o;
        return this.x == that.x && this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.z;
        return result;
    }

    public Set<HorizontalCoords> getPerpendicular() {
        return ImmutableSet.of((Object)new HorizontalCoords(this.z, this.x), (Object)new HorizontalCoords(this.z, -this.x));
    }
}

