/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border.points;

import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;

public class BorderPoint {
    private PointType type;
    private int x;
    private int z;
    private BorderPoint outerBorderPoint = null;
    private BorderPoint referencePoint;
    private BorderPoint closestBorderPoint;
    private double distanceToBorder = Double.MAX_VALUE;
    private int structureBorderDistance = Integer.MAX_VALUE;

    public BorderPoint(int x, int z, PointType type) {
        this.x = x;
        this.z = z;
        this.type = type;
    }

    public PointType getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setOuterBorderAndReferencePoint(BorderPoint outerBorder, BorderPoint referencePoint) {
        this.outerBorderPoint = outerBorder;
        this.referencePoint = referencePoint;
    }

    public boolean hasOuterBorderPointSet() {
        return this.outerBorderPoint != null;
    }

    public int getStructureBorderDistance() {
        return this.structureBorderDistance;
    }

    public BorderPoint getClosestBorderPoint() {
        return this.closestBorderPoint;
    }

    public double getDistanceToBorder() {
        return this.distanceToBorder;
    }

    public boolean updateBorderCoordsIfCloser(int distance, BorderPoint point) {
        if (distance < this.structureBorderDistance) {
            this.structureBorderDistance = distance;
            this.closestBorderPoint = point;
            int xDiff = Math.abs(this.x - this.closestBorderPoint.x);
            int zDiff = Math.abs(this.z - this.closestBorderPoint.z);
            this.distanceToBorder = Math.sqrt((double)xDiff * (double)xDiff + (double)(zDiff * zDiff));
            return true;
        }
        return false;
    }

    public BorderPoint getOuterBorderPoint() {
        return this.outerBorderPoint;
    }

    public BorderPoint getReferencePoint() {
        return this.referencePoint;
    }
}

