/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.IRuleFixer;

public class DataFixManager {
    private static List<IRuleFixer> fixes = new ArrayList<IRuleFixer>();
    private static StructureTemplate.Version currentVersion = new StructureTemplate.Version(1, 0);
    private static final Comparator<IRuleFixer> VERSION_ASCENDING = (o1, o2) -> {
        if (o1.getVersion().isGreaterThan(o2.getVersion())) {
            return 1;
        }
        if (o2.getVersion().isGreaterThan(o1.getVersion())) {
            return -1;
        }
        return 0;
    };

    private DataFixManager() {
    }

    public static StructureTemplate.Version getCurrentVersion() {
        return currentVersion;
    }

    public static void registerRuleFixer(IRuleFixer fixer) {
        if (fixer.getVersion().isGreaterThan(currentVersion)) {
            currentVersion = fixer.getVersion();
        }
        fixes.add(fixer);
    }

    public static FixResult<Tuple<String, List<String>>> fixRuleData(StructureTemplate.Version templateVersion, String ruleName, List<String> data) {
        FixResult.Builder<Tuple> resultBuilder = new FixResult.Builder<Tuple>();
        List modifiedData = data;
        String modifiedRuleName = ruleName;
        for (IRuleFixer fixer : fixes.stream().filter(f -> f.getVersion().isGreaterThan(templateVersion)).sorted(VERSION_ASCENDING).collect(Collectors.toList())) {
            if (!fixer.isForRule(modifiedRuleName)) continue;
            Tuple<String, List<String>> fixed = resultBuilder.updateAndGetData(fixer.fix(modifiedRuleName, modifiedData));
            modifiedRuleName = (String)fixed.func_76341_a();
            modifiedData = (List)fixed.func_76340_b();
        }
        return resultBuilder.build(new Tuple((Object)modifiedRuleName, modifiedData));
    }
}

