/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;

public class BlockMetaToBlockStateFixer
extends RuleDataFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 5);
    private static final Map<String, String> ruleBlockNameMapping = new ImmutableMap.Builder().put((Object)"modBlockDefault", (Object)"blockName").put((Object)"awTorqueMulti", (Object)"blockId").put((Object)"rotatable", (Object)"blockId").put((Object)"inventory", (Object)"blockName").put((Object)"vanillaSign", (Object)"blockName").put((Object)"vanillaSkull", (Object)"blockName").put((Object)"blockTile", (Object)"blockName").put((Object)"vanillaFlowerPot", (Object)"blockName").put((Object)"doors", (Object)"blockName").put((Object)"vanillaBlocks", (Object)"blockName").build();

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        NBTTagCompound tag;
        try {
            tag = JsonToNBT.func_180713_a((String)data.substring("JSON:".length()));
        }
        catch (NBTException e) {
            AncientWarfareStructure.LOG.error("Error getting nbt from json string: ", (Throwable)e);
            return new FixResult.NotModified<String>(data);
        }
        String blockName = tag.func_74779_i(ruleBlockNameMapping.get(ruleName));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null) {
            AncientWarfareStructure.LOG.warn("block {} cannot be found in registry replacing with air", (Object)blockName);
            tag.func_74782_a("blockState", (NBTBase)NBTHelper.getBlockStateTag(Blocks.field_150350_a.func_176223_P()));
        } else {
            tag.func_74782_a("blockState", (NBTBase)NBTHelper.getBlockStateTag(block.func_176203_a(tag.func_74762_e("meta"))));
        }
        return new FixResult.Modified<String>("JSON:" + tag.toString(), "BlockMetaToBlockStateFixer");
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return ruleBlockNameMapping.containsKey(ruleName);
    }
}

