/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import java.util.Optional;
import net.shadowmage.ancientwarfare.npc.datafixes.FactionExpansionEntityFixer;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json.Json;

public class FactionExpansionFixer
extends RuleDataFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 2);

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        Optional<Json.JsonObject> parsedJson = Json.parseJson(data);
        if (!parsedJson.isPresent()) {
            return new FixResult.NotModified<String>(data);
        }
        Json.JsonObject json = parsedJson.get();
        Json.JsonObject entityData = json.getObject("val").getObject("entityData");
        if (entityData.getObject("val").getObject("factionName") != null) {
            Json.JsonValue factionName = entityData.getObject("val").getObject("factionName").getValue("val");
            factionName.setStringValue(FactionExpansionEntityFixer.RENAMES.getOrDefault(factionName.getStringValue(), factionName.getStringValue()));
        }
        return new FixResult.Modified<String>(Json.getJsonData(json), "FactionExpansionFixer");
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return ruleName.equals("AWNpc");
    }
}

