/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleNameFixerBase;

public class RuleNameConsolidationFixer
extends RuleNameFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 4);
    private static final Map<String, String> nameMapping = new ImmutableMap.Builder().put((Object)"awAdvancedSpawner", (Object)"blockTile").put((Object)"awCoreLogic", (Object)"blockTile").put((Object)"awStructureLogic", (Object)"blockTile").put((Object)"awTorqueTile", (Object)"awWorksite").put((Object)"awAutomationLogic", (Object)"blockTile").put((Object)"modContainerDefault", (Object)"blockTile").put((Object)"modHangingDefault", (Object)"vanillaHangingEntity").put((Object)"modAnimalDefault", (Object)"vanillaEntities").put((Object)"modEquippedDefault", (Object)"vanillaLogicEntity").put((Object)"awTownHall", (Object)"blockTile").put((Object)"vanillaDoors", (Object)"doors").put((Object)"vanillaInventory", (Object)"inventory").put((Object)"vanillaLogic", (Object)"blockTile").put((Object)"awWorksite", (Object)"rotatable").put((Object)"modBlockDefault", (Object)"vanillaBlocks").build();

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return nameMapping.containsKey(ruleName);
    }

    @Override
    protected FixResult<String> fixName(String ruleName) {
        if (nameMapping.containsKey(ruleName)) {
            return new FixResult.Modified<String>(nameMapping.get(ruleName), "RuleNameConsolidationFixer");
        }
        return new FixResult.NotModified<String>(ruleName);
    }
}

