/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.init.AWStructureItems;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderTicked;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureBuilder;

public class TemplateRuleStructureBuilder
extends TemplateRuleBlock {
    public static final String PLUGIN_NAME = "AWStructureBuilder";
    String templateName;
    EnumFacing facing;

    public TemplateRuleStructureBuilder(World world, BlockPos pos, IBlockState state, int turns) {
        super(state, turns);
        WorldTools.getTile((IBlockAccess)world, pos, TileStructureBuilder.class).ifPresent(structureBuilder -> {
            StructureBuilderTicked builder = structureBuilder.getBuilder();
            this.templateName = builder.getTemplate().name;
            this.facing = this.rotateFacing(turns, builder.getBuildFace());
        });
    }

    public TemplateRuleStructureBuilder() {
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        builder.placeBlock(pos, BlockTools.rotateFacing(this.state, turns), 0);
        WorldTools.getTile((IBlockAccess)world, pos, TileStructureBuilder.class).ifPresent(structureBuilder -> {
            structureBuilder.setOwner(Owner.EMPTY);
            EnumFacing placementFacing = this.rotateFacing(turns, this.facing);
            AWStructureItems.STRUCTURE_BUILDER_TICKED.setupStructureBuilder(world, pos, (TileStructureBuilder)structureBuilder, this.templateName, placementFacing);
        });
    }

    private EnumFacing rotateFacing(int turns, EnumFacing facing) {
        for (int i = 0; i < turns; ++i) {
            facing = facing.func_176746_e();
        }
        return facing;
    }

    @Override
    protected ItemStack getStack() {
        ItemStack stack = new ItemStack((Item)AWStructureItems.STRUCTURE_BUILDER_TICKED);
        stack.func_77983_a("structureName", (NBTBase)new NBTTagString(this.templateName));
        return stack;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74778_a("templateName", this.templateName);
        tag.func_74768_a("facing", this.facing.func_176736_b());
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 0;
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.templateName = tag.func_74779_i("templateName");
        this.facing = EnumFacing.field_176754_o[tag.func_74762_e("facing")];
    }
}

