/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;

public class TileColored
extends TileUpdatable {
    private static final String DYE_COLOR_TAG = "dyeColor";
    private static final String COLOR_TAG = "color";
    private static final String UNLOCALIZED_NAME_PART_TAG = "unlocalizedNamePart";
    private static final String CUSTOM_DATA_TAG = "customData";
    private boolean customColor = false;
    private int dyeColor = -1;
    private int color = -1;
    private String customData;
    private String unlocalizedNamePart;

    public void setDyeColor(int dyeColor) {
        this.dyeColor = dyeColor;
        this.customColor = false;
    }

    public void setColor(int color) {
        this.color = color;
        this.customColor = true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        if (this.customColor) {
            return this.color;
        }
        return EnumDyeColor.func_176766_a((int)this.dyeColor).func_193350_e();
    }

    public ItemStack getPickBlock() {
        ItemStack item = new ItemStack(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        if (this.customColor) {
            item.func_77982_d(new NBTBuilder().setInteger(COLOR_TAG, this.color).setString(CUSTOM_DATA_TAG, this.customData).setString(UNLOCALIZED_NAME_PART_TAG, this.unlocalizedNamePart).build());
        } else {
            item.func_77983_a(DYE_COLOR_TAG, (NBTBase)new NBTTagInt(this.dyeColor));
        }
        return item;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
    }

    protected void readNBT(NBTTagCompound compound) {
        this.customColor = compound.func_74767_n("customColor");
        this.dyeColor = compound.func_74762_e(DYE_COLOR_TAG);
        if (compound.func_74764_b(COLOR_TAG)) {
            this.color = compound.func_74762_e(COLOR_TAG);
        }
        this.customData = compound.func_74779_i(CUSTOM_DATA_TAG);
        this.unlocalizedNamePart = compound.func_74779_i(UNLOCALIZED_NAME_PART_TAG);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeNBT(compound);
        return super.func_189515_b(compound);
    }

    protected void writeNBT(NBTTagCompound compound) {
        compound.func_74757_a("customColor", this.customColor);
        if (this.dyeColor != -1) {
            compound.func_74768_a(DYE_COLOR_TAG, this.dyeColor);
        }
        if (this.color != -1) {
            compound.func_74768_a(COLOR_TAG, this.color);
        }
        if (this.customData != null) {
            compound.func_74778_a(CUSTOM_DATA_TAG, this.customData);
        }
        if (this.unlocalizedNamePart != null) {
            compound.func_74778_a(UNLOCALIZED_NAME_PART_TAG, this.unlocalizedNamePart);
        }
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        this.writeNBT(tag);
        super.writeUpdateNBT(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.readNBT(tag);
    }

    public void setCustomData(String customData) {
        this.customData = customData;
    }

    public void setFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b(DYE_COLOR_TAG)) {
            this.setDyeColor(tag.func_74762_e(DYE_COLOR_TAG));
        } else if (tag.func_74764_b(COLOR_TAG)) {
            this.setColor(tag.func_74762_e(COLOR_TAG));
            this.customData = tag.func_74779_i(CUSTOM_DATA_TAG);
            this.unlocalizedNamePart = tag.func_74779_i(UNLOCALIZED_NAME_PART_TAG);
        }
    }
}

