/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.TextUtils;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureEntry;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

public class TileProtectionFlag
extends TileUpdatable {
    private static final String NAME_TAG = "name";
    private static final String PLAYER_PROFILE_TAG = "playerProfile";
    private static final String OWNER_TAG = "owner";
    private static final float UNBREAKABLE = -1.0f;
    private int topColor = -1;
    private int bottomColor = -1;
    private String name = "";
    private Owner owner = Owner.EMPTY;
    private GameProfile playerProfile;

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.writeNBT(tag);
    }

    private NBTTagCompound writeNBT(NBTTagCompound tag) {
        tag.func_74768_a("topColor", this.topColor);
        tag.func_74768_a("bottomColor", this.bottomColor);
        if (this.owner != Owner.EMPTY) {
            tag.func_74782_a(OWNER_TAG, (NBTBase)this.owner.serializeToNBT(new NBTTagCompound()));
            tag.func_74782_a(PLAYER_PROFILE_TAG, (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.playerProfile));
        }
        return tag;
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.readNBT(tag);
    }

    private void readNBT(NBTTagCompound tag) {
        this.topColor = tag.func_74762_e("topColor");
        this.bottomColor = tag.func_74762_e("bottomColor");
        if (tag.func_74764_b(OWNER_TAG)) {
            this.owner = Owner.deserializeFromNBT(tag.func_74775_l(OWNER_TAG));
            this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l(PLAYER_PROFILE_TAG));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        AWGameData.INSTANCE.getData(this.field_145850_b, StructureMap.class).getStructureAt(this.field_145850_b, this.field_174879_c).ifPresent(structure -> {
            structure.setProtectionFlagPos(this.field_174879_c);
            if (!this.field_145850_b.field_72995_K) {
                NetworkHandler.sendToAllPlayers(new PacketStructureEntry(this.field_145850_b.field_73011_w.getDimension(), structure.getChunkX(), structure.getChunkZ(), (StructureEntry)structure, false));
            }
        });
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
        this.name = compound.func_74779_i(NAME_TAG);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = this.writeNBT(super.func_189515_b(compound));
        tag.func_74778_a(NAME_TAG, this.name);
        return tag;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((Block)AWStructureBlocks.PROTECTION_FLAG);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNBT(tag);
        tag.func_74778_a(NAME_TAG, this.name);
        stack.func_77982_d(tag);
        return stack;
    }

    public void setFromStack(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            this.readNBT(tag);
            this.name = tag.func_74779_i(NAME_TAG);
        }
    }

    public int getTopColor() {
        return this.topColor;
    }

    public int getBottomColor() {
        return this.bottomColor;
    }

    public void onActivatedBy(EntityPlayer player) {
        if (this.isPlayerOwned() || this.field_145850_b.field_72995_K) {
            return;
        }
        Optional<StructureEntry> structure = AWGameData.INSTANCE.getData(this.field_145850_b, StructureMap.class).getStructureAt(this.field_145850_b, this.field_174879_c);
        if (!structure.isPresent()) {
            return;
        }
        if (this.checkStructureConquered(structure.get(), player)) {
            this.turnOffSoundBlocks(structure.get());
            this.setOwner(player, player.func_146103_bH());
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_conquered", new Object[]{structure.get().getName()}), true);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, AWStructureSounds.PROTECTION_FLAG_CLAIM, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.func_70296_d();
        BlockTools.notifyBlockUpdate(this);
    }

    private void turnOffSoundBlocks(StructureEntry structure) {
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)structure.getBB().min, (BlockPos)structure.getBB().max)) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != AWStructureBlocks.SOUND_BLOCK) continue;
            WorldTools.getTile((IBlockAccess)this.field_145850_b, blockPos, TileSoundBlock.class).ifPresent(TileSoundBlock::turnOffByProtectionFlag);
        }
    }

    private void setOwner(EntityPlayer player, GameProfile playerProfile) {
        this.owner = new Owner(player);
        this.playerProfile = playerProfile;
    }

    private boolean checkStructureConquered(StructureEntry structure, EntityPlayer player) {
        AxisAlignedBB boundingBox = structure.getBB().getAABB();
        for (NpcFaction factionNpc : this.field_145850_b.func_72872_a(NpcFaction.class, boundingBox)) {
            if (factionNpc.isPassive()) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_hostile_alive", new Object[]{TextUtils.getSimpleBlockPosString(factionNpc.func_180425_c())}), true);
            return false;
        }
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)structure.getBB().min, (BlockPos)structure.getBB().max)) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != AWStructureBlocks.ADVANCED_SPAWNER) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_spawner_present", new Object[]{TextUtils.getSimpleBlockPosString(blockPos)}), true);
            return false;
        }
        return true;
    }

    public boolean isPlayerOwned() {
        return this.owner != Owner.EMPTY;
    }

    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 3, 1));
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, float original) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player) ? original : -1.0f;
    }

    public boolean shouldProtectAgainst(EntityPlayer player) {
        return !this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }
}

