/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockTotemPart;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;

public class TileTotemPart
extends TileMulti {
    private static final String VARIANT_TAG = "variant";
    private BlockTotemPart.Variant variant = BlockTotemPart.Variant.BASE;
    private BlockTotemPart.Variant dropVariant = BlockTotemPart.Variant.BASE;

    public void setVariant(BlockTotemPart.Variant variant) {
        this.variant = variant;
        this.dropVariant = variant;
    }

    public BlockTotemPart.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void setMainBlockPos(BlockPos mainBlockPos) {
        super.setMainBlockPos(mainBlockPos);
        this.getMainBlockPos().ifPresent(mainPos -> WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos, TileTotemPart.class).ifPresent(te -> {
            this.dropVariant = te.getVariant();
        }));
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74774_a(VARIANT_TAG, (byte)this.variant.getId());
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.variant = BlockTotemPart.Variant.fromId(tag.func_74771_c(VARIANT_TAG));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.variant = BlockTotemPart.Variant.fromId(compound.func_74771_c(VARIANT_TAG));
        this.getMainBlockPos().ifPresent(mainPos -> WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos, TileTotemPart.class).ifPresent(te -> {
            this.dropVariant = te.getVariant();
        }));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74774_a(VARIANT_TAG, (byte)this.variant.getId());
        return compound;
    }

    @Override
    public Set<BlockPos> getAdditionalPositions(IBlockState state) {
        return this.getVariant().getAdditionalPartPositions(this.field_174879_c, (EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public BlockTotemPart.Variant getDropVariant() {
        return this.dropVariant;
    }
}

