/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;

public class TownPlacementValidator {
    private static int maxSize = 21;
    private static final int MIN_STRUCTURE_DISTANCE = 16;

    private TownPlacementValidator() {
    }

    static TownBoundingArea findGenerationPosition(World world, int x, int z) {
        int diff;
        if (world == null) {
            return null;
        }
        if (TownPlacementValidator.isTownClose(world, x, z)) {
            return null;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        int height = TownPlacementValidator.getTopFilledHeight(world.func_72964_e(cx, cz), x, z);
        if (height <= 0) {
            return null;
        }
        int minY = Math.max(0, world.func_181545_F() - 3);
        TownBoundingArea area = new TownBoundingArea();
        area.minY = Math.max(minY, height - 2);
        area.maxY = Math.min(255, area.minY + 17);
        area.chunkMinX = cx;
        area.chunkMaxX = cx;
        area.chunkMinZ = cz;
        area.chunkMaxZ = cz;
        StructureMap sm = AWGameData.INSTANCE.getPerWorldData(world, StructureMap.class);
        Collection<StructureEntry> structureList = sm.getEntriesNear(world, x, z, maxSize + 2, true, new ArrayList<StructureEntry>());
        if (TownPlacementValidator.isStructureInside(structureList, x, z, area.minY, area.maxY)) {
            return null;
        }
        TownPlacementValidator.expandBoundingArea(world, area, structureList);
        int cw = area.getChunkWidth();
        int cl = area.getChunkLength();
        if (cw > cl * 2) {
            diff = cw - cl * 2;
            while (diff > 0) {
                --area.chunkMaxX;
                if (--diff <= 0) continue;
                ++area.chunkMinX;
                --diff;
            }
        }
        if (cl > cw * 2) {
            diff = cl - cw * 2;
            while (diff > 0) {
                --area.chunkMaxZ;
                if (--diff <= 0) continue;
                ++area.chunkMinZ;
                --diff;
            }
        }
        return area;
    }

    private static boolean isStructureInside(Collection<StructureEntry> structureList, int chunkX, int chunkZ, int minY, int maxY) {
        for (StructureEntry structure : structureList) {
            if (!structure.getBB().crossWith((chunkX >> 16) - 16, minY, (chunkZ >> 16) - 16, (chunkX + 1 >> 16) + 16, maxY, (chunkZ + 1 >> 16) + 16)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTownClose(World world, int x, int z) {
        TownMap tm = AWGameData.INSTANCE.getPerWorldData(world, TownMap.class);
        if (tm == null) {
            return false;
        }
        int minDist = AWStructureStatics.townClosestDistance * 16;
        float dist = tm.getClosestTown(x, z, minDist * 2);
        return dist < (float)minDist;
    }

    private static void expandBoundingArea(World world, TownBoundingArea area, Collection<StructureEntry> structureList) {
        boolean xneg = true;
        boolean xpos = true;
        boolean zneg = true;
        boolean zpos = true;
        boolean didExpand = false;
        do {
            didExpand = false;
            if (xneg && area.getChunkWidth() <= maxSize) {
                xneg = TownPlacementValidator.tryExpandXNeg(world, area, structureList);
                boolean bl = didExpand = didExpand || xneg;
            }
            if (xpos && area.getChunkWidth() <= maxSize) {
                xpos = TownPlacementValidator.tryExpandXPos(world, area, structureList);
                boolean bl = didExpand = didExpand || xpos;
            }
            if (zneg && area.getChunkLength() <= maxSize) {
                zneg = TownPlacementValidator.tryExpandZNeg(world, area, structureList);
                boolean bl = didExpand = didExpand || zneg;
            }
            if (!zpos || area.getChunkLength() > maxSize) continue;
            zpos = TownPlacementValidator.tryExpandZPos(world, area, structureList);
            boolean bl = didExpand = didExpand || zpos;
        } while (didExpand && (area.getChunkWidth() <= maxSize || area.getChunkLength() <= maxSize));
    }

    private static boolean tryExpandXNeg(World world, TownBoundingArea area, Collection<StructureEntry> structureList) {
        int cx = area.chunkMinX - 1;
        for (int z = area.chunkMinZ; z <= area.chunkMaxZ; ++z) {
            if (TownPlacementValidator.isAverageHeightWithin(world, cx, z, area.minY, area.maxY) && !TownPlacementValidator.isStructureInside(structureList, cx, z, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMinX = cx;
        return true;
    }

    private static boolean tryExpandXPos(World world, TownBoundingArea area, Collection<StructureEntry> structureList) {
        int cx = area.chunkMaxX + 1;
        for (int z = area.chunkMinZ; z <= area.chunkMaxZ; ++z) {
            if (TownPlacementValidator.isAverageHeightWithin(world, cx, z, area.minY, area.maxY) && !TownPlacementValidator.isStructureInside(structureList, cx, z, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMaxX = cx;
        return true;
    }

    private static boolean tryExpandZNeg(World world, TownBoundingArea area, Collection<StructureEntry> structureList) {
        int cz = area.chunkMinZ - 1;
        for (int x = area.chunkMinX; x <= area.chunkMaxX; ++x) {
            if (TownPlacementValidator.isAverageHeightWithin(world, x, cz, area.minY, area.maxY) && !TownPlacementValidator.isStructureInside(structureList, x, cz, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMinZ = cz;
        return true;
    }

    private static boolean tryExpandZPos(World world, TownBoundingArea area, Collection<StructureEntry> structureList) {
        int cz = area.chunkMaxZ + 1;
        for (int x = area.chunkMinX; x <= area.chunkMaxX; ++x) {
            if (TownPlacementValidator.isAverageHeightWithin(world, x, cz, area.minY, area.maxY) && !TownPlacementValidator.isStructureInside(structureList, x, cz, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMaxZ = cz;
        return true;
    }

    private static boolean isAverageHeightWithin(World world, int cx, int cz, int min, int max) {
        Chunk chunk = world.func_72964_e(cx, cz);
        int total = 0;
        for (int x = cx << 4; x < (cx << 4) + 16; ++x) {
            for (int z = cz << 4; z < (cz << 4) + 16; ++z) {
                int val = TownPlacementValidator.getTopFilledHeight(chunk, x, z);
                if (val < 0) {
                    return false;
                }
                total += val;
            }
        }
        return (total /= 256) >= min && total <= max;
    }

    private static int getTopFilledHeight(Chunk chunk, int x, int z) {
        int maxY;
        for (int y = maxY = chunk.func_76625_h() + 15; y > 0; --y) {
            IBlockState state = chunk.func_177435_g(new BlockPos(x, y, z));
            Block block = state.func_177230_c();
            if (AWStructureStatics.isSkippable(state)) continue;
            if (state.func_185904_a().func_76224_d()) {
                if (y >= 56) continue;
                return -1;
            }
            if (!AWStructureStatics.isValidTargetBlock(state)) {
                AncientWarfareStructure.LOG.debug("rejecting town chunk for non-target block: " + block + " :: " + chunk.field_76635_g + ":" + chunk.field_76647_h);
                return -1;
            }
            return y;
        }
        return -1;
    }
}

