/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPlacementValidator;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;

public class WorldTownGenerator
implements IWorldGenerator {
    public static final WorldTownGenerator INSTANCE = new WorldTownGenerator();

    private WorldTownGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos cc = world.func_175694_M();
        double distSq = cc.func_177954_c((double)(chunkX * 16), (double)cc.func_177956_o(), (double)(chunkZ * 16));
        if (AWStructureStatics.withinProtectionRange(distSq)) {
            return;
        }
        if (random.nextFloat() < AWStructureStatics.townGenerationChance) {
            WorldGenTickHandler.INSTANCE.addChunkForTownGeneration(world, chunkX, chunkZ);
        }
    }

    public void attemptGeneration(World world, int blockX, int blockZ) {
        List<TownTemplate> templates = TownTemplateManager.INSTANCE.getTemplatesValidAtPosition(world, blockX, blockZ);
        if (templates.isEmpty()) {
            return;
        }
        TownBoundingArea area = TownPlacementValidator.findGenerationPosition(world, blockX, blockZ);
        if (area == null) {
            return;
        }
        Optional<TownTemplate> t = TownTemplateManager.INSTANCE.selectTemplateFittingArea(world, area, templates);
        if (!t.isPresent()) {
            return;
        }
        TownTemplate template = t.get();
        if (area.getChunkWidth() - 1 > template.getMaxSize()) {
            area.chunkMaxX = area.chunkMinX + template.getMaxSize();
        }
        if (area.getChunkLength() - 1 > template.getMaxSize()) {
            area.chunkMaxZ = area.chunkMinZ + template.getMaxSize();
        }
        this.generate(world, area, template);
    }

    public void generate(World world, TownBoundingArea area, TownTemplate template) {
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        StructureBB bb = new StructureBB(new BlockPos(area.getBlockMinX(), area.getMinY(), area.getBlockMinZ()), new BlockPos(area.getBlockMaxX(), area.getMaxY(), area.getBlockMaxZ()));
        StructureEntry entry = new StructureEntry(bb, template.getTownTypeName(), template.getClusterValue(), area.getCenterX() >> 4, area.getCenterZ() >> 4);
        map.setGeneratedAt(world, area.getCenterX(), area.getSurfaceY(), area.getCenterZ(), EnumFacing.DOWN, entry, false);
        AWGameData.INSTANCE.getPerWorldData(world, TownMap.class).setGenerated(bb);
        new TownGenerator(world, area, template).generate();
    }
}

