/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;

public class BlockSongPlayData
extends SongPlayData {
    public static final String SOUND_RANGE_TAG = "soundRange";
    private boolean playOnce = false;
    private int playerRange = 20;
    private boolean limitedRepetitions = false;
    private int repetitions = 1;
    private boolean whenInRange = false;
    private TimeOfDay timeOfDay = TimeOfDay.ANY;
    private boolean protectionFlagTurnOff = false;
    private int soundRange = 16;

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.playOnce = tag.func_74767_n("playOnce");
        this.playerRange = tag.func_74762_e("playerRange");
        this.limitedRepetitions = tag.func_74767_n("limitedRepetitions");
        this.repetitions = tag.func_74762_e("repetitions");
        this.whenInRange = tag.func_74767_n("whenInRange");
        this.timeOfDay = TimeOfDay.getById(tag.func_74762_e("timeOfDay"));
        this.protectionFlagTurnOff = tag.func_74767_n("protectionFlagTurnOff");
        this.setSoundRange(tag.func_74764_b(SOUND_RANGE_TAG) ? tag.func_74762_e(SOUND_RANGE_TAG) : 64);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74757_a("playOnce", this.playOnce);
        tag.func_74768_a("playerRange", this.playerRange);
        tag.func_74757_a("limitedRepetitions", this.limitedRepetitions);
        tag.func_74768_a("repetitions", this.repetitions);
        tag.func_74757_a("whenInRange", this.whenInRange);
        tag.func_74768_a("timeOfDay", this.timeOfDay.getId());
        tag.func_74757_a("protectionFlagTurnOff", this.protectionFlagTurnOff);
        tag.func_74768_a(SOUND_RANGE_TAG, this.soundRange);
        return tag;
    }

    public void setPlayerRange(int playerRange) {
        this.playerRange = playerRange;
    }

    public int getPlayerRange() {
        return this.playerRange;
    }

    public void setPlayOnce(boolean playOnce) {
        this.playOnce = playOnce;
    }

    public boolean getPlayOnce() {
        return this.playOnce;
    }

    public void setLimitedRepetitions(boolean limitedRepetitions) {
        this.limitedRepetitions = limitedRepetitions;
    }

    public boolean getLimitedRepetitions() {
        return this.limitedRepetitions;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public boolean getWhenInRange() {
        return this.whenInRange;
    }

    public void setWhenInRange(boolean whenInRange) {
        this.whenInRange = whenInRange;
    }

    public void setTimeOfDay(TimeOfDay timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public TimeOfDay getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setProtectionFlagTurnOff(boolean protectionFlagTurnOff) {
        this.protectionFlagTurnOff = protectionFlagTurnOff;
    }

    public boolean getProtectionFlagTurnOff() {
        return this.protectionFlagTurnOff;
    }

    public void setSoundRange(int value) {
        this.soundRange = Math.max(16, value);
    }

    public int getSoundRange() {
        return this.soundRange;
    }

    public static enum TimeOfDay {
        ANY(0),
        DAY(1){

            @Override
            public boolean takesPlaceNow(World world) {
                return TimeOfDay.isDayTimeClient(world);
            }
        }
        ,
        NIGHT(2){

            @Override
            public boolean takesPlaceNow(World world) {
                return !TimeOfDay.isDayTimeClient(world);
            }
        };

        private int id;
        private static final Map<Integer, TimeOfDay> VALUES;

        private TimeOfDay(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static TimeOfDay getById(int id) {
            return VALUES.get(id);
        }

        public boolean takesPlaceNow(World world) {
            return true;
        }

        private static boolean isDayTimeClient(World world) {
            long time = world.func_72820_D();
            return time >= 23500L || time <= 12500L;
        }

        static {
            VALUES = new HashMap<Integer, TimeOfDay>();
            for (TimeOfDay value : TimeOfDay.values()) {
                VALUES.put(value.getId(), value);
            }
        }
    }
}

