/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.shadowmage.ancientwarfare.structure.util.IRespawnData;
import net.shadowmage.ancientwarfare.structure.util.RespawnData;
import net.shadowmage.ancientwarfare.structure.util.RespawnDataCapabilityProvider;

public class CapabilityRespawnData {
    private static final String RESPAWN_POS_TAG = "respawnPos";
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";
    private static final String SPAWN_TIME_TAG = "spawnTime";
    @CapabilityInject(value=IRespawnData.class)
    public static Capability<IRespawnData> RESPAWN_DATA_CAPABILITY = null;

    private CapabilityRespawnData() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IRespawnData.class, (Capability.IStorage)new Capability.IStorage<IRespawnData>(){

            public NBTBase writeNBT(Capability<IRespawnData> capability, IRespawnData instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                if (instance.canRespawn()) {
                    tag.func_74772_a(CapabilityRespawnData.RESPAWN_POS_TAG, instance.getRespawnPos().func_177986_g());
                    tag.func_74782_a(CapabilityRespawnData.SPAWNER_SETTINGS_TAG, (NBTBase)instance.getSpawnerSettings());
                    tag.func_74772_a(CapabilityRespawnData.SPAWN_TIME_TAG, instance.getSpawnTime());
                }
                return tag;
            }

            public void readNBT(Capability<IRespawnData> capability, IRespawnData instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound tag;
                if (nbt instanceof NBTTagCompound && (tag = (NBTTagCompound)nbt).func_74764_b(CapabilityRespawnData.RESPAWN_POS_TAG)) {
                    instance.setRespawnPos(BlockPos.func_177969_a((long)tag.func_74763_f(CapabilityRespawnData.RESPAWN_POS_TAG)));
                    instance.setSpawnerSettings(tag.func_74775_l(CapabilityRespawnData.SPAWNER_SETTINGS_TAG));
                    instance.setSpawnTime(tag.func_74763_f(CapabilityRespawnData.SPAWN_TIME_TAG));
                }
            }
        }, RespawnData::new);
    }

    public static void onAttach(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("ancientwarfarestructure", "respawn_data"), (ICapabilityProvider)new RespawnDataCapabilityProvider());
        }
    }
}

