/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class LootHelper {
    public static final String FACTION_NAME_TAG = "factionName";

    private LootHelper() {
    }

    public static <T extends TileEntity> void fillWithLoot(T te, @Nullable EntityPlayer player) {
        LootHelper.processLoot(te, player, new ILootTableProcessor(){

            public <U extends TileEntity> void processLootTable(U te, @Nullable EntityPlayer player, LootSettings lootSettings, ResourceLocation lootTable) {
                if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    InventoryTools.generateLootFor(te.func_145831_w(), player, (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), te.func_145831_w().field_73012_v, lootTable, lootSettings.getLootRolls());
                }
            }
        });
    }

    public static <T extends TileEntity> void dropLoot(T te, @Nullable EntityPlayer player) {
        LootHelper.processLoot(te, player, new ILootTableProcessor(){

            public <U extends TileEntity> void processLootTable(U te, @Nullable EntityPlayer player, LootSettings lootSettings, ResourceLocation lootTable) {
                for (int roll = 0; roll < lootSettings.getLootRolls(); ++roll) {
                    InventoryTools.dropItemsInWorld(te.func_145831_w(), InventoryTools.getLootStacks(te.func_145831_w(), player, te.func_145831_w().field_73012_v, lootTable), te.func_174877_v().func_177971_a(LootHelper.getPlayerOffset(te, player)));
                }
            }
        });
    }

    private static Vec3i getPlayerOffset(TileEntity te, @Nullable EntityPlayer player) {
        if (player == null) {
            return new Vec3i(0, 0, 0);
        }
        BlockPos playerVector = player.func_180425_c().func_177973_b((Vec3i)te.func_174877_v());
        int offsetX = Math.max(Math.min(playerVector.func_177958_n(), 1), -1);
        int offsetY = Math.max(Math.min(playerVector.func_177956_o(), 1), 0);
        int offsetZ = Math.max(Math.min(playerVector.func_177952_p(), 1), -1);
        return new Vec3i(offsetX, offsetY, offsetZ);
    }

    public static <T extends TileEntity> void processLoot(T te, @Nullable EntityPlayer player, ILootTableProcessor lootTableProcessor) {
        LootSettings lootSettings = ((ISpecialLootContainer)te).getLootSettings();
        if (!te.func_145831_w().field_72995_K) {
            if (lootSettings.getSplashPotion()) {
                lootSettings.setSplashPotion(false);
                ItemStack potion = new ItemStack((Item)Items.field_185155_bH);
                PotionUtils.func_185184_a((ItemStack)potion, lootSettings.getEffects());
                BlockPos startPos = te.func_174877_v().func_177971_a(LootHelper.getPlayerOffset(te, player));
                EntityPotion potionEntity = new EntityPotion(te.func_145831_w(), (double)startPos.func_177958_n() + 0.5, (double)startPos.func_177956_o() + 0.5, (double)startPos.func_177952_p() + 0.5, potion);
                Vec3d playerPos = player == null ? new Vec3d((double)startPos.func_177958_n() + 0.5, (double)startPos.func_177956_o() + 1.5, (double)startPos.func_177952_p() + 0.5) : new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
                potionEntity.func_70186_c(playerPos.field_72450_a - ((double)startPos.func_177958_n() + 0.5), playerPos.field_72448_b - ((double)startPos.func_177956_o() + 0.5), playerPos.field_72449_c - ((double)startPos.func_177952_p() + 0.5), 0.5f, 1.0f);
                te.func_145831_w().func_72838_d((Entity)potionEntity);
            }
            if (lootSettings.getSpawnEntity()) {
                lootSettings.setSpawnEntity(false);
                EntityTools.spawnEntity(te.func_145831_w(), lootSettings.getEntity(), lootSettings.getEntityNBT(), te.func_174877_v().func_177971_a(LootHelper.getPlayerOffset(te, player)));
            }
            if (lootSettings.hasLoot()) {
                lootSettings.setHasLoot(false);
                lootSettings.getLootTableName().ifPresent(lootTable -> {
                    lootTableProcessor.processLootTable(te, player, lootSettings, (ResourceLocation)lootTable);
                    BlockTools.notifyBlockUpdate(te);
                });
                lootSettings.removeLoot();
            }
        }
    }

    public static interface ILootTableProcessor {
        public <T extends TileEntity> void processLootTable(T var1, @Nullable EntityPlayer var2, LootSettings var3, ResourceLocation var4);
    }
}

