/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import net.minecraft.util.EnumFacing;
import net.shadowmage.ancientwarfare.core.util.Trig;

public class RotationLimit {
    public static final RotationLimit NO_LIMIT = new RotationLimit(){

        @Override
        public boolean isWithinLimit(float rotationYaw) {
            return true;
        }
    };
    private float min = 0.0f;
    private float max = 0.0f;

    private RotationLimit() {
    }

    public RotationLimit(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public boolean isWithinLimit(float rotationYaw) {
        return Trig.isAngleBetween(rotationYaw, this.min, this.max);
    }

    public float restrictToLimit(float rotationYaw) {
        float maxDiff;
        float minDiff = Math.abs(Trig.getAngleDiffSigned(rotationYaw, this.min));
        return minDiff < (maxDiff = Math.abs(Trig.getAngleDiffSigned(rotationYaw, this.max))) ? this.min : this.max;
    }

    public float getMidPoint() {
        return this.min + (this.max - this.min) / 2.0f;
    }

    public static class FacingQuarter
    extends RotationLimit {
        public FacingQuarter(EnumFacing facing) {
            super(facing.func_185119_l() - 45.0f, facing.func_185119_l() + 45.0f);
        }
    }

    public static class FacingThreeQuarters
    extends RotationLimit {
        public FacingThreeQuarters(EnumFacing facing) {
            super(facing.func_185119_l() - 135.0f, facing.func_185119_l() + 135.0f);
        }
    }
}

