/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public abstract class Ammo
implements IAmmo {
    int entityDamage;
    int vehicleDamage;
    private static final float GRAVITY_FACTOR = 0.024525002f;
    String configName = "none";
    ResourceLocation modelTexture = new ResourceLocation("missingno");
    boolean isRocket = false;
    boolean isArrow = false;
    boolean isPersistent = false;
    boolean isFlaming = false;
    boolean isProximityAmmo = false;
    boolean isCraftable = true;
    boolean isEnabled = true;
    boolean isTorpedo = false;
    float groundProximity = 0.0f;
    float entityProximity = 0.0f;
    float ammoWeight = 10.0f;
    float renderScale = 1.0f;
    int secondaryAmmoCount = 0;
    private ResourceLocation registryName;

    public Ammo(String regName) {
        this.registryName = new ResourceLocation("ancientwarfarevehicle", regName);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public void setEntityDamage(int damage) {
        if (damage < 0) {
            damage = 0;
        }
        this.entityDamage = damage;
    }

    @Override
    public void setVehicleDamage(int damage) {
        if (damage < 0) {
            damage = 0;
        }
        this.vehicleDamage = damage;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean val) {
        this.isEnabled = val;
    }

    @Override
    public boolean isTorpedo() {
        return this.isTorpedo;
    }

    @Override
    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    @Override
    public boolean isRocket() {
        return this.isRocket;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public boolean updateAsArrow() {
        return this.isArrow;
    }

    @Override
    public boolean isAvailableAsItem() {
        return this.isCraftable;
    }

    @Override
    public float getAmmoWeight() {
        return this.ammoWeight;
    }

    @Override
    public boolean isAmmoValidFor(VehicleBase vehicle) {
        return true;
    }

    @Override
    public float getRenderScale() {
        return this.renderScale;
    }

    @Override
    public float getGravityFactor() {
        return 0.024525002f;
    }

    @Override
    public int getEntityDamage() {
        return this.entityDamage;
    }

    @Override
    public int getVehicleDamage() {
        return this.vehicleDamage;
    }

    @Override
    public boolean isFlaming() {
        return this.isFlaming;
    }

    @Override
    public boolean isPenetrating() {
        return false;
    }

    @Override
    public IAmmo getSecondaryAmmoType() {
        return null;
    }

    @Override
    public int getSecondaryAmmoTypeCount() {
        return this.secondaryAmmoCount;
    }

    @Override
    public boolean hasSecondaryAmmo() {
        return false;
    }

    @Override
    public boolean isProximityAmmo() {
        return this.isProximityAmmo;
    }

    @Override
    public float entityProximity() {
        return this.entityProximity;
    }

    @Override
    public float groundProximity() {
        return this.groundProximity;
    }

    private void breakBlockAndDrop(World world, BlockPos pos) {
        if (!AWVehicleStatics.blockDestruction) {
            return;
        }
        BlockTools.breakBlockAndDrop(world, pos);
    }

    protected void igniteBlock(World world, int x, int y, int z, int maxSearch) {
        if (!AWVehicleStatics.blockFires) {
            return;
        }
        for (int i = 0; i < maxSearch && y - i >= 1; ++i) {
            BlockPos curPos = new BlockPos(x, y - i, z);
            if (world.func_175623_d(curPos) || !world.func_175623_d(curPos.func_177984_a())) continue;
            world.func_180501_a(curPos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 3);
        }
    }

    public static boolean shouldEffectEntity(World world, Entity entity, MissileBase missile) {
        if (!AWVehicleStatics.allowFriendlyFire && missile.shooterLiving instanceof NpcBase) {
            NpcBase npc = (NpcBase)missile.shooterLiving;
            if (entity instanceof NpcBase) {
                Owner targetNpcOwner = ((NpcBase)entity).getOwner();
                return !npc.getOwner().isOwnerOrSameTeamOrFriend(world, targetNpcOwner.getUUID(), targetNpcOwner.getName());
            }
            if (entity instanceof EntityPlayer) {
                return !npc.getOwner().isOwnerOrSameTeamOrFriend(world, entity.func_110124_au(), entity.func_70005_c_());
            }
        }
        return true;
    }

    protected void setBlockToLava(World world, int x, int y, int z, int maxSearch) {
        if (!AWVehicleStatics.blockFires) {
            return;
        }
        for (int i = 0; i < maxSearch && y - i >= 1; ++i) {
            BlockPos curPos = new BlockPos(x, y - i, z);
            if (world.func_175623_d(curPos)) continue;
            if (!world.func_175623_d(curPos.func_177984_a())) break;
            world.func_180501_a(curPos.func_177984_a(), Blocks.field_150353_l.func_176223_P(), 3);
            break;
        }
    }

    protected void createExplosion(World world, @Nullable MissileBase missile, float x, float y, float z, float power) {
        boolean destroyBlocks = AWVehicleStatics.blockDestruction;
        boolean fires = AWVehicleStatics.blockFires;
        world.func_72885_a((Entity)missile, (double)x, (double)y, (double)z, power, fires, destroyBlocks);
    }

    protected void spawnGroundBurst(World world, RayTraceResult hit, float maxVelocity, IAmmo type, int count, float minPitch, Entity shooter) {
        Vec3i dirVec = hit.field_178784_b.func_176730_m();
        Vec3d hitVec = hit.field_72307_f.func_72441_c((double)((float)dirVec.func_177958_n() * 0.2f), (double)((float)dirVec.func_177956_o() * 0.2f), (double)((float)dirVec.func_177952_p() * 0.2f));
        this.spawnBurst(world, maxVelocity, type, count, minPitch, shooter, hit.field_178784_b, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c);
    }

    private void spawnBurst(World world, float maxVelocity, IAmmo type, int count, float minPitch, Entity shooter, EnumFacing sideHit, float x, float y, float z) {
        world.func_72885_a(null, (double)x, (double)y, (double)z, 0.25f, false, true);
        this.createExplosion(world, null, x, y, z, 1.0f);
        float randRange = 90.0f - minPitch;
        if (type.hasSecondaryAmmo()) {
            count = type.getSecondaryAmmoTypeCount();
            type = type.getSecondaryAmmoType();
        }
        for (int i = 0; i < count; ++i) {
            float velocity;
            float randVelocity;
            float yaw;
            float pitch;
            if (sideHit.func_176740_k().func_176720_b()) {
                pitch = 90.0f - world.field_73012_v.nextFloat() * randRange;
                yaw = world.field_73012_v.nextFloat() * 360.0f;
                randVelocity = world.field_73012_v.nextFloat();
                randVelocity = randVelocity < 0.5f ? 0.5f : randVelocity;
                velocity = maxVelocity * randVelocity;
            } else {
                float maxYaw;
                float minYaw = this.getMinYaw(sideHit);
                if (minYaw > (maxYaw = this.getMaxYaw(sideHit))) {
                    float tmp = maxYaw;
                    maxYaw = minYaw;
                    minYaw = tmp;
                }
                float yawRange = maxYaw - minYaw;
                pitch = 90.0f - world.field_73012_v.nextFloat() * randRange;
                yaw = minYaw + world.field_73012_v.nextFloat() * yawRange;
                randVelocity = world.field_73012_v.nextFloat();
                randVelocity = randVelocity < 0.5f ? 0.5f : randVelocity;
                velocity = maxVelocity * randVelocity;
            }
            MissileBase missile = this.getMissileByType(type, world, x, y, z, yaw, pitch, velocity, shooter);
            world.func_72838_d((Entity)missile);
        }
    }

    private float getMinYaw(EnumFacing side) {
        switch (side) {
            case NORTH: {
                return 315.0f;
            }
            case SOUTH: {
                return 135.0f;
            }
            case WEST: {
                return 45.0f;
            }
            case EAST: {
                return 225.0f;
            }
        }
        return 0.0f;
    }

    private float getMaxYaw(EnumFacing side) {
        switch (side) {
            case NORTH: {
                return 405.0f;
            }
            case SOUTH: {
                return 225.0f;
            }
            case WEST: {
                return 135.0f;
            }
            case EAST: {
                return 315.0f;
            }
        }
        return 0.0f;
    }

    protected void spawnAirBurst(World world, float x, float y, float z, float maxVelocity, IAmmo type, int count, Entity shooter) {
        this.spawnBurst(world, maxVelocity, type, count, -90.0f, shooter, EnumFacing.DOWN, x, y, z);
    }

    protected void breakAroundOnLevel(World world, BlockPos origin, BlockPos center, float maxHardness) {
        this.affectBlock(world, origin, center, maxHardness);
        this.affectBlock(world, origin, center.func_177978_c(), maxHardness);
        this.affectBlock(world, origin, center.func_177974_f(), maxHardness);
        this.affectBlock(world, origin, center.func_177976_e(), maxHardness);
        this.affectBlock(world, origin, center.func_177968_d(), maxHardness);
        this.affectBlock(world, origin, center.func_177978_c().func_177974_f(), maxHardness);
        this.affectBlock(world, origin, center.func_177974_f().func_177968_d(), maxHardness);
        this.affectBlock(world, origin, center.func_177968_d().func_177976_e(), maxHardness);
        this.affectBlock(world, origin, center.func_177976_e().func_177978_c(), maxHardness);
    }

    private void affectBlock(World world, BlockPos origin, BlockPos pos, float maxHardness) {
        double distanceAdjustedHardness = (double)maxHardness - origin.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) * 15.0;
        if (distanceAdjustedHardness > 0.0 && distanceAdjustedHardness > (double)world.func_180495_p(pos).func_185887_b(world, pos)) {
            this.breakBlockAndDrop(world, pos);
        }
    }

    private MissileBase getMissileByType(IAmmo type, World world, float x, float y, float z, float yaw, float pitch, float velocity, Entity shooter) {
        MissileBase missile = new MissileBase(world);
        missile.setShooter(shooter);
        missile.setMissileParams2(type, x, y, z, yaw, pitch, velocity);
        return missile;
    }
}

