/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoSoldierArrow
extends Ammo {
    public AmmoSoldierArrow(int damage, boolean flaming) {
        super("ammo_soldier_arrow_" + damage + (flaming ? "_flaming" : ""));
        this.ammoWeight = 1.0f;
        this.renderScale = 0.125f;
        this.vehicleDamage = damage;
        this.entityDamage = damage;
        this.isArrow = true;
        this.isRocket = false;
        this.isPersistent = true;
        this.isFlaming = flaming;
        this.isCraftable = false;
        this.configName = flaming ? "soldier_arrow_flame_" + damage : "soldier_arrow_" + damage;
        this.modelTexture = damage <= 5 ? new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/arrow_wood.png") : new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/arrow_iron.png");
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            ent.func_70097_a(DamageType.causeEntityMissileDamage(missile.shooterLiving, this.isFlaming, false), (float)this.getEntityDamage());
        }
    }
}

