/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoTorpedo
extends Ammo {
    public AmmoTorpedo(int weight) {
        super("ammo_torpedo_" + weight);
        this.isEnabled = false;
        this.isPersistent = false;
        this.isArrow = true;
        this.isRocket = false;
        this.isTorpedo = true;
        this.ammoWeight = weight;
        this.configName = "torpedo_" + weight;
        this.entityDamage = weight * 2;
        this.vehicleDamage = weight * 2;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        if (!world.field_72995_K) {
            float maxPower = 7.0f;
            float powerPercent = this.ammoWeight / 45.0f;
            float power = maxPower * powerPercent;
            this.createExplosion(world, missile, x, y, z, power);
        }
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            float maxPower = 7.0f;
            float powerPercent = this.ammoWeight / 45.0f;
            float power = maxPower * powerPercent;
            this.createExplosion(world, missile, x, y, z, power);
        }
    }
}

