/*
 * Decompiled with CFR 0.152.
 */
package scavengePlugins.reSkillable;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.skill.Skill;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BaseElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropPlayerSkillLevelUp
extends BaseResourceProperty
implements IResourceEffect {
    Skill skill;
    int levels;

    public PropPlayerSkillLevelUp(JsonObject obj) {
        super(obj, "level_up_re_skill");
        this.skill = (Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation(obj.get("name").getAsString()));
        if (this.skill == null) {
            throw new RuntimeException("Skill [" + obj.get("name").getAsString() + "] is a null that is not allowed");
        }
        this.levels = JsonUtil.getOrDefault((JsonObject)obj, (String)"levels", (int)1);
        this.setJEIInfo("+" + this.levels + " for the Skill [" + this.skill.getName() + "]");
    }

    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo info = data.getSkillInfo(this.skill);
        for (int i = 0; i < this.levels; ++i) {
            info.levelUp();
        }
        data.saveAndSync();
        return true;
    }

    public static class PlayerSkillLevelUp
    extends BaseResourceFactory {
        public PlayerSkillLevelUp() {
            super("level_up_re_skill", IResourceFactory.PropertyType.Effect);
        }

        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerSkillLevelUp(obj);
        }

        public void addExample(JsonObject obj) {
            obj.addProperty("name", "attack");
            obj.addProperty("levels", (Number)5);
        }

        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to Level up a Skill");
            map.addElement(new TextElement("name", "").setDescription("The Skill should be upgraded"));
            map.addElement((BaseElement)new IntElement("levels", 1, "How many levels the skill should get"));
            return map;
        }
    }
}

