/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import net.minecraft.util.EnumFacing;

public class ImmutableDirectionHolder {
    private final int[] offset;
    private final EnumFacing[] directions;

    public ImmutableDirectionHolder(EnumFacing ... facings) {
        this.directions = facings;
        this.offset = this.getOffsets();
    }

    private int[] getOffsets() {
        int[] offsets = new int[3];
        for (EnumFacing fd : this.directions) {
            if (fd == null) continue;
            offsets[0] = offsets[0] + fd.func_82601_c();
            offsets[1] = offsets[1] + fd.func_96559_d();
            offsets[2] = offsets[2] + fd.func_82599_e();
        }
        return offsets;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public EnumFacing[] getDirections() {
        return this.directions;
    }

    public String toString() {
        String s = "ImmutableDirectionHolder : ";
        for (EnumFacing direction : this.directions) {
            s = s + direction;
            s = s + " ";
        }
        s = s + " | ";
        int[] nArray = this.offset;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float v = nArray[i];
            s = s + v;
            s = s + " ";
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableDirectionHolder)) {
            return false;
        }
        ImmutableDirectionHolder o = (ImmutableDirectionHolder)obj;
        if (this.directions.length != o.directions.length) {
            return false;
        }
        return this.offset[0] == o.offset[0] && this.offset[1] == o.offset[1] && this.offset[2] == o.offset[2];
    }

    public int hashCode() {
        return 0x100000 * this.offset[0] + 1024 * this.offset[1] + this.offset[2];
    }
}

