/*
 * Decompiled with CFR 0.152.
 */
package jsit.campfire.tileentity;

import javax.annotation.Nullable;
import jsit.campfire.ConfigManager;
import jsit.campfire.RegistryManager;
import jsit.campfire.network.MsgTileEntityUpdate;
import jsit.campfire.network.PacketHandler;
import jsit.campfire.util.Misc;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCampfire
extends TileEntity
implements ITickable {
    Long startWorldTotalTime;
    Long startWorldTime;
    Long lastCookTotalTime;
    Long lastCookTime;
    Long ticker;
    Item curItem;
    ItemStack curResult;
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityCampfire.this.func_70296_d();
            if (!((TileEntityCampfire)TileEntityCampfire.this).field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MsgTileEntityUpdate(TileEntityCampfire.this));
            }
        }
    };

    public TileEntityCampfire() {
        this.lastCookTime = this.ticker = Long.valueOf(-1L);
        this.lastCookTotalTime = this.ticker;
        this.startWorldTime = this.ticker;
        this.startWorldTotalTime = this.ticker;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74772_a("ticker", this.ticker.longValue());
        tag.func_74772_a("startWorldTotalTime", this.startWorldTotalTime.longValue());
        tag.func_74772_a("startWorldTime", this.startWorldTime.longValue());
        tag.func_74772_a("lastCookTotalTime", this.lastCookTotalTime.longValue());
        tag.func_74772_a("lastCookTime", this.lastCookTime.longValue());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.ticker = tag.func_74763_f("ticker");
        this.startWorldTotalTime = tag.func_74763_f("startWorldTotalTime");
        this.startWorldTime = tag.func_74763_f("startWorldTime");
        this.lastCookTotalTime = tag.func_74763_f("lastCookTotalTime");
        this.lastCookTime = tag.func_74763_f("lastCookTime");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private boolean canAdd(ItemStack heldItem) {
        boolean returnValue = false;
        if (ConfigManager.defaultBehavior) {
            returnValue = FurnaceRecipes.func_77602_a().func_151395_a(heldItem).func_77973_b() instanceof ItemFood;
        }
        if (ConfigManager.enableWhitelist && ConfigManager.itemWhitelist.indexOf(heldItem.func_77973_b().getRegistryName().toString()) >= 0) {
            returnValue = true;
        }
        if (ConfigManager.enableBlacklist && ConfigManager.itemBlacklist.indexOf(heldItem.func_77973_b().getRegistryName().toString()) >= 0) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!heldItem.func_190926_b()) {
            if (this.inventory.getStackInSlot(0).func_190926_b() && this.canAdd(heldItem)) {
                player.func_184611_a(hand, this.inventory.insertItem(0, heldItem, false));
                this.lastCookTotalTime = world.func_82737_E();
                this.lastCookTime = world.func_72820_D();
            } else if (this.inventory.getStackInSlot(0).func_77969_a(heldItem)) {
                player.func_184611_a(hand, this.inventory.insertItem(0, heldItem, false));
            }
        } else if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND && !this.inventory.getStackInSlot(0).func_190926_b()) {
            this.inventory = Misc.spawnInventoryInWorld(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.inventory);
        }
        this.inventory = Misc.spawnInventoryStackInWorld(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.inventory, 1);
        return true;
    }

    public void breakBlock(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.8f, 1.0f);
        if (this.inventory != null && !world.field_72995_K) {
            Misc.spawnInventoryInWorld(world, pos, this.inventory);
        }
    }

    public void func_73660_a() {
        Long curTotalTime = this.field_145850_b.func_82737_E();
        Long curWorldTime = this.field_145850_b.func_72820_D();
        this.ticker = this.ticker + 1L;
        if (this.ticker == 0L) {
            this.startWorldTime = curWorldTime;
            this.startWorldTotalTime = curTotalTime;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.ticker % 2L == 0L) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_174877_v().func_177958_n() + 0.5 + ((double)Misc.rand.nextFloat() - 0.5) / 2.0, (double)((float)this.func_174877_v().func_177956_o() + Misc.rand.nextFloat() / 5.0f) + 0.2, (double)this.func_174877_v().func_177952_p() + 0.5 + ((double)Misc.rand.nextFloat() - 0.5) / 2.0, 0.0, (double)(Misc.rand.nextFloat() / 50.0f), 0.0, new int[0]);
            }
            if (this.ticker % 13L == 0L) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5 + ((double)Misc.rand.nextFloat() - 0.5) / 4.0, (double)((float)this.func_174877_v().func_177956_o() + Misc.rand.nextFloat() / 5.0f + 1.0f), (double)this.func_174877_v().func_177952_p() + 0.5 + ((double)Misc.rand.nextFloat() - 0.5) / 4.0, 0.0, (double)(Misc.rand.nextFloat() / 100.0f) + 0.015, 0.0, new int[0]);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            Long numCooks;
            if (this.ticker % 60L == 0L && Misc.rand.nextBoolean()) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            if (!this.inventory.getStackInSlot(0).func_190926_b() && (numCooks = ConfigManager.burnoutTime != -1 ? Long.valueOf(Math.min(Math.max(curTotalTime - this.lastCookTotalTime, curWorldTime - this.lastCookTime), (long)ConfigManager.burnoutTime) / 100L) : Long.valueOf(Math.max(curTotalTime - this.lastCookTotalTime, curWorldTime - this.lastCookTime) / 100L)) > 0L) {
                int numInt = Math.min(this.inventory.getStackInSlot(0).func_190916_E(), numCooks.intValue());
                ItemStack remainder = this.inventory.insertItem(1, new ItemStack(FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0)).func_77973_b(), FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0)).func_190916_E() * numInt, FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0)).func_77960_j()), false);
                this.inventory.getStackInSlot(0).func_190918_g(numInt);
                if (!remainder.func_190926_b()) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, remainder));
                }
                this.lastCookTotalTime = curTotalTime;
                this.lastCookTime = curWorldTime;
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MsgTileEntityUpdate(this));
            }
            if (ConfigManager.burnoutTime != -1 && Math.max(curWorldTime - this.startWorldTime, Math.max(this.ticker, curTotalTime - this.startWorldTotalTime)) > (long)ConfigManager.burnoutTime) {
                this.breakBlock(this.field_145850_b, this.field_174879_c);
                if (RegistryManager.ash.func_176196_c(this.field_145850_b, this.field_174879_c)) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, RegistryManager.ash.func_176223_P());
                }
            }
        }
    }
}

